goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = (((typeof window !== 'undefined'))?goog.style.transition.isSupported():null);

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_47503 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_dom[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_47503(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_47506 = (function (this$){
var x__4428__auto__ = (((this$ == null))?null:this$);
var m__4429__auto__ = (shadow.dom._to_svg[goog.typeOf(x__4428__auto__)]);
if((!((m__4429__auto__ == null)))){
return (m__4429__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4429__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4429__auto__.call(null,this$));
} else {
var m__4426__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__4426__auto__ == null)))){
return (m__4426__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4426__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__4426__auto__.call(null,this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_47506(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__46448 = coll;
var G__46449 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__46448,G__46449) : shadow.dom.lazy_native_coll_seq.call(null,G__46448,G__46449));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__4126__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__4369__auto__,writer__4370__auto__,opt__4371__auto__){
return cljs.core._write(writer__4370__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null);
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__46477 = arguments.length;
switch (G__46477) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__46489 = arguments.length;
switch (G__46489) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__46495 = arguments.length;
switch (G__46495) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__46509 = arguments.length;
switch (G__46509) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__46515 = arguments.length;
switch (G__46515) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__46523 = arguments.length;
switch (G__46523) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
}));
}catch (e46529){if((e46529 instanceof Object)){
var e = e46529;
return console.log("didnt support attachEvent",el,e);
} else {
throw e46529;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__4126__auto__ = (!((typeof document !== 'undefined')));
if(or__4126__auto__){
return or__4126__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__46535 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__46536 = null;
var count__46537 = (0);
var i__46538 = (0);
while(true){
if((i__46538 < count__46537)){
var el = chunk__46536.cljs$core$IIndexed$_nth$arity$2(null,i__46538);
var handler_47544__$1 = ((function (seq__46535,chunk__46536,count__46537,i__46538,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__46535,chunk__46536,count__46537,i__46538,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_47544__$1);


var G__47545 = seq__46535;
var G__47546 = chunk__46536;
var G__47547 = count__46537;
var G__47548 = (i__46538 + (1));
seq__46535 = G__47545;
chunk__46536 = G__47546;
count__46537 = G__47547;
i__46538 = G__47548;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46535);
if(temp__5735__auto__){
var seq__46535__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46535__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46535__$1);
var G__47549 = cljs.core.chunk_rest(seq__46535__$1);
var G__47550 = c__4556__auto__;
var G__47551 = cljs.core.count(c__4556__auto__);
var G__47552 = (0);
seq__46535 = G__47549;
chunk__46536 = G__47550;
count__46537 = G__47551;
i__46538 = G__47552;
continue;
} else {
var el = cljs.core.first(seq__46535__$1);
var handler_47554__$1 = ((function (seq__46535,chunk__46536,count__46537,i__46538,el,seq__46535__$1,temp__5735__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});})(seq__46535,chunk__46536,count__46537,i__46538,el,seq__46535__$1,temp__5735__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_47554__$1);


var G__47557 = cljs.core.next(seq__46535__$1);
var G__47558 = null;
var G__47559 = (0);
var G__47560 = (0);
seq__46535 = G__47557;
chunk__46536 = G__47558;
count__46537 = G__47559;
i__46538 = G__47560;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__46557 = arguments.length;
switch (G__46557) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null,e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__46561 = cljs.core.seq(events);
var chunk__46562 = null;
var count__46563 = (0);
var i__46564 = (0);
while(true){
if((i__46564 < count__46563)){
var vec__46589 = chunk__46562.cljs$core$IIndexed$_nth$arity$2(null,i__46564);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46589,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46589,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__47568 = seq__46561;
var G__47569 = chunk__46562;
var G__47570 = count__46563;
var G__47571 = (i__46564 + (1));
seq__46561 = G__47568;
chunk__46562 = G__47569;
count__46563 = G__47570;
i__46564 = G__47571;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46561);
if(temp__5735__auto__){
var seq__46561__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46561__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46561__$1);
var G__47572 = cljs.core.chunk_rest(seq__46561__$1);
var G__47573 = c__4556__auto__;
var G__47574 = cljs.core.count(c__4556__auto__);
var G__47575 = (0);
seq__46561 = G__47572;
chunk__46562 = G__47573;
count__46563 = G__47574;
i__46564 = G__47575;
continue;
} else {
var vec__46598 = cljs.core.first(seq__46561__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46598,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46598,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__47576 = cljs.core.next(seq__46561__$1);
var G__47577 = null;
var G__47578 = (0);
var G__47579 = (0);
seq__46561 = G__47576;
chunk__46562 = G__47577;
count__46563 = G__47578;
i__46564 = G__47579;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__46607 = cljs.core.seq(styles);
var chunk__46608 = null;
var count__46609 = (0);
var i__46610 = (0);
while(true){
if((i__46610 < count__46609)){
var vec__46637 = chunk__46608.cljs$core$IIndexed$_nth$arity$2(null,i__46610);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46637,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46637,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__47583 = seq__46607;
var G__47584 = chunk__46608;
var G__47585 = count__46609;
var G__47586 = (i__46610 + (1));
seq__46607 = G__47583;
chunk__46608 = G__47584;
count__46609 = G__47585;
i__46610 = G__47586;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46607);
if(temp__5735__auto__){
var seq__46607__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46607__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46607__$1);
var G__47588 = cljs.core.chunk_rest(seq__46607__$1);
var G__47589 = c__4556__auto__;
var G__47590 = cljs.core.count(c__4556__auto__);
var G__47591 = (0);
seq__46607 = G__47588;
chunk__46608 = G__47589;
count__46609 = G__47590;
i__46610 = G__47591;
continue;
} else {
var vec__46646 = cljs.core.first(seq__46607__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46646,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46646,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__47592 = cljs.core.next(seq__46607__$1);
var G__47593 = null;
var G__47594 = (0);
var G__47595 = (0);
seq__46607 = G__47592;
chunk__46608 = G__47593;
count__46609 = G__47594;
i__46610 = G__47595;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__46657_47596 = key;
var G__46657_47597__$1 = (((G__46657_47596 instanceof cljs.core.Keyword))?G__46657_47596.fqn:null);
switch (G__46657_47597__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_47601 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__4126__auto__ = goog.string.startsWith(ks_47601,"data-");
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return goog.string.startsWith(ks_47601,"aria-");
}
})())){
el.setAttribute(ks_47601,value);
} else {
(el[ks_47601] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__46713){
var map__46716 = p__46713;
var map__46716__$1 = (((((!((map__46716 == null))))?(((((map__46716.cljs$lang$protocol_mask$partition0$ & (64))) || ((cljs.core.PROTOCOL_SENTINEL === map__46716.cljs$core$ISeq$))))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__46716):map__46716);
var props = map__46716__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46716__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__46727 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46727,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46727,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46727,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__46734 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__46734,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__46734;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__46742 = arguments.length;
switch (G__46742) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5735__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5735__auto__)){
var n = temp__5735__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__46753){
var vec__46759 = p__46753;
var seq__46760 = cljs.core.seq(vec__46759);
var first__46761 = cljs.core.first(seq__46760);
var seq__46760__$1 = cljs.core.next(seq__46760);
var nn = first__46761;
var first__46761__$1 = cljs.core.first(seq__46760__$1);
var seq__46760__$2 = cljs.core.next(seq__46760__$1);
var np = first__46761__$1;
var nc = seq__46760__$2;
var node = vec__46759;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__46767 = nn;
var G__46768 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__46767,G__46768) : create_fn.call(null,G__46767,G__46768));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null,nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__46769 = nn;
var G__46770 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__46769,G__46770) : create_fn.call(null,G__46769,G__46770));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__46776 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46776,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46776,(1),null);
var seq__46780_47614 = cljs.core.seq(node_children);
var chunk__46781_47615 = null;
var count__46782_47616 = (0);
var i__46783_47617 = (0);
while(true){
if((i__46783_47617 < count__46782_47616)){
var child_struct_47619 = chunk__46781_47615.cljs$core$IIndexed$_nth$arity$2(null,i__46783_47617);
var children_47621 = shadow.dom.dom_node(child_struct_47619);
if(cljs.core.seq_QMARK_(children_47621)){
var seq__46852_47623 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_47621));
var chunk__46855_47624 = null;
var count__46856_47625 = (0);
var i__46857_47626 = (0);
while(true){
if((i__46857_47626 < count__46856_47625)){
var child_47627 = chunk__46855_47624.cljs$core$IIndexed$_nth$arity$2(null,i__46857_47626);
if(cljs.core.truth_(child_47627)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47627);


var G__47630 = seq__46852_47623;
var G__47631 = chunk__46855_47624;
var G__47632 = count__46856_47625;
var G__47633 = (i__46857_47626 + (1));
seq__46852_47623 = G__47630;
chunk__46855_47624 = G__47631;
count__46856_47625 = G__47632;
i__46857_47626 = G__47633;
continue;
} else {
var G__47634 = seq__46852_47623;
var G__47635 = chunk__46855_47624;
var G__47636 = count__46856_47625;
var G__47637 = (i__46857_47626 + (1));
seq__46852_47623 = G__47634;
chunk__46855_47624 = G__47635;
count__46856_47625 = G__47636;
i__46857_47626 = G__47637;
continue;
}
} else {
var temp__5735__auto___47639 = cljs.core.seq(seq__46852_47623);
if(temp__5735__auto___47639){
var seq__46852_47641__$1 = temp__5735__auto___47639;
if(cljs.core.chunked_seq_QMARK_(seq__46852_47641__$1)){
var c__4556__auto___47642 = cljs.core.chunk_first(seq__46852_47641__$1);
var G__47643 = cljs.core.chunk_rest(seq__46852_47641__$1);
var G__47644 = c__4556__auto___47642;
var G__47645 = cljs.core.count(c__4556__auto___47642);
var G__47646 = (0);
seq__46852_47623 = G__47643;
chunk__46855_47624 = G__47644;
count__46856_47625 = G__47645;
i__46857_47626 = G__47646;
continue;
} else {
var child_47648 = cljs.core.first(seq__46852_47641__$1);
if(cljs.core.truth_(child_47648)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47648);


var G__47649 = cljs.core.next(seq__46852_47641__$1);
var G__47650 = null;
var G__47651 = (0);
var G__47652 = (0);
seq__46852_47623 = G__47649;
chunk__46855_47624 = G__47650;
count__46856_47625 = G__47651;
i__46857_47626 = G__47652;
continue;
} else {
var G__47653 = cljs.core.next(seq__46852_47641__$1);
var G__47654 = null;
var G__47655 = (0);
var G__47656 = (0);
seq__46852_47623 = G__47653;
chunk__46855_47624 = G__47654;
count__46856_47625 = G__47655;
i__46857_47626 = G__47656;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_47621);
}


var G__47657 = seq__46780_47614;
var G__47658 = chunk__46781_47615;
var G__47659 = count__46782_47616;
var G__47660 = (i__46783_47617 + (1));
seq__46780_47614 = G__47657;
chunk__46781_47615 = G__47658;
count__46782_47616 = G__47659;
i__46783_47617 = G__47660;
continue;
} else {
var temp__5735__auto___47661 = cljs.core.seq(seq__46780_47614);
if(temp__5735__auto___47661){
var seq__46780_47662__$1 = temp__5735__auto___47661;
if(cljs.core.chunked_seq_QMARK_(seq__46780_47662__$1)){
var c__4556__auto___47663 = cljs.core.chunk_first(seq__46780_47662__$1);
var G__47664 = cljs.core.chunk_rest(seq__46780_47662__$1);
var G__47665 = c__4556__auto___47663;
var G__47666 = cljs.core.count(c__4556__auto___47663);
var G__47667 = (0);
seq__46780_47614 = G__47664;
chunk__46781_47615 = G__47665;
count__46782_47616 = G__47666;
i__46783_47617 = G__47667;
continue;
} else {
var child_struct_47670 = cljs.core.first(seq__46780_47662__$1);
var children_47671 = shadow.dom.dom_node(child_struct_47670);
if(cljs.core.seq_QMARK_(children_47671)){
var seq__46889_47672 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_47671));
var chunk__46891_47673 = null;
var count__46892_47674 = (0);
var i__46893_47675 = (0);
while(true){
if((i__46893_47675 < count__46892_47674)){
var child_47676 = chunk__46891_47673.cljs$core$IIndexed$_nth$arity$2(null,i__46893_47675);
if(cljs.core.truth_(child_47676)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47676);


var G__47677 = seq__46889_47672;
var G__47678 = chunk__46891_47673;
var G__47679 = count__46892_47674;
var G__47680 = (i__46893_47675 + (1));
seq__46889_47672 = G__47677;
chunk__46891_47673 = G__47678;
count__46892_47674 = G__47679;
i__46893_47675 = G__47680;
continue;
} else {
var G__47683 = seq__46889_47672;
var G__47684 = chunk__46891_47673;
var G__47685 = count__46892_47674;
var G__47686 = (i__46893_47675 + (1));
seq__46889_47672 = G__47683;
chunk__46891_47673 = G__47684;
count__46892_47674 = G__47685;
i__46893_47675 = G__47686;
continue;
}
} else {
var temp__5735__auto___47687__$1 = cljs.core.seq(seq__46889_47672);
if(temp__5735__auto___47687__$1){
var seq__46889_47688__$1 = temp__5735__auto___47687__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46889_47688__$1)){
var c__4556__auto___47689 = cljs.core.chunk_first(seq__46889_47688__$1);
var G__47690 = cljs.core.chunk_rest(seq__46889_47688__$1);
var G__47691 = c__4556__auto___47689;
var G__47692 = cljs.core.count(c__4556__auto___47689);
var G__47693 = (0);
seq__46889_47672 = G__47690;
chunk__46891_47673 = G__47691;
count__46892_47674 = G__47692;
i__46893_47675 = G__47693;
continue;
} else {
var child_47699 = cljs.core.first(seq__46889_47688__$1);
if(cljs.core.truth_(child_47699)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_47699);


var G__47701 = cljs.core.next(seq__46889_47688__$1);
var G__47702 = null;
var G__47703 = (0);
var G__47704 = (0);
seq__46889_47672 = G__47701;
chunk__46891_47673 = G__47702;
count__46892_47674 = G__47703;
i__46893_47675 = G__47704;
continue;
} else {
var G__47705 = cljs.core.next(seq__46889_47688__$1);
var G__47706 = null;
var G__47707 = (0);
var G__47708 = (0);
seq__46889_47672 = G__47705;
chunk__46891_47673 = G__47706;
count__46892_47674 = G__47707;
i__46893_47675 = G__47708;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_47671);
}


var G__47709 = cljs.core.next(seq__46780_47662__$1);
var G__47710 = null;
var G__47711 = (0);
var G__47712 = (0);
seq__46780_47614 = G__47709;
chunk__46781_47615 = G__47710;
count__46782_47616 = G__47711;
i__46783_47617 = G__47712;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__46956 = cljs.core.seq(node);
var chunk__46957 = null;
var count__46958 = (0);
var i__46959 = (0);
while(true){
if((i__46959 < count__46958)){
var n = chunk__46957.cljs$core$IIndexed$_nth$arity$2(null,i__46959);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__47718 = seq__46956;
var G__47719 = chunk__46957;
var G__47720 = count__46958;
var G__47721 = (i__46959 + (1));
seq__46956 = G__47718;
chunk__46957 = G__47719;
count__46958 = G__47720;
i__46959 = G__47721;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__46956);
if(temp__5735__auto__){
var seq__46956__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46956__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__46956__$1);
var G__47723 = cljs.core.chunk_rest(seq__46956__$1);
var G__47724 = c__4556__auto__;
var G__47725 = cljs.core.count(c__4556__auto__);
var G__47726 = (0);
seq__46956 = G__47723;
chunk__46957 = G__47724;
count__46958 = G__47725;
i__46959 = G__47726;
continue;
} else {
var n = cljs.core.first(seq__46956__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null,n));


var G__47729 = cljs.core.next(seq__46956__$1);
var G__47730 = null;
var G__47731 = (0);
var G__47732 = (0);
seq__46956 = G__47729;
chunk__46957 = G__47730;
count__46958 = G__47731;
i__46959 = G__47732;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__46975 = arguments.length;
switch (G__46975) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__46987 = arguments.length;
switch (G__46987) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__47000 = arguments.length;
switch (G__47000) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__4126__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__4126__auto__)){
return or__4126__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__4742__auto__ = [];
var len__4736__auto___47750 = arguments.length;
var i__4737__auto___47751 = (0);
while(true){
if((i__4737__auto___47751 < len__4736__auto___47750)){
args__4742__auto__.push((arguments[i__4737__auto___47751]));

var G__47753 = (i__4737__auto___47751 + (1));
i__4737__auto___47751 = G__47753;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((0) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__4743__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__47028_47756 = cljs.core.seq(nodes);
var chunk__47029_47757 = null;
var count__47030_47758 = (0);
var i__47031_47759 = (0);
while(true){
if((i__47031_47759 < count__47030_47758)){
var node_47761 = chunk__47029_47757.cljs$core$IIndexed$_nth$arity$2(null,i__47031_47759);
fragment.appendChild(shadow.dom._to_dom(node_47761));


var G__47762 = seq__47028_47756;
var G__47763 = chunk__47029_47757;
var G__47764 = count__47030_47758;
var G__47765 = (i__47031_47759 + (1));
seq__47028_47756 = G__47762;
chunk__47029_47757 = G__47763;
count__47030_47758 = G__47764;
i__47031_47759 = G__47765;
continue;
} else {
var temp__5735__auto___47766 = cljs.core.seq(seq__47028_47756);
if(temp__5735__auto___47766){
var seq__47028_47767__$1 = temp__5735__auto___47766;
if(cljs.core.chunked_seq_QMARK_(seq__47028_47767__$1)){
var c__4556__auto___47768 = cljs.core.chunk_first(seq__47028_47767__$1);
var G__47769 = cljs.core.chunk_rest(seq__47028_47767__$1);
var G__47770 = c__4556__auto___47768;
var G__47771 = cljs.core.count(c__4556__auto___47768);
var G__47772 = (0);
seq__47028_47756 = G__47769;
chunk__47029_47757 = G__47770;
count__47030_47758 = G__47771;
i__47031_47759 = G__47772;
continue;
} else {
var node_47773 = cljs.core.first(seq__47028_47767__$1);
fragment.appendChild(shadow.dom._to_dom(node_47773));


var G__47774 = cljs.core.next(seq__47028_47767__$1);
var G__47775 = null;
var G__47776 = (0);
var G__47777 = (0);
seq__47028_47756 = G__47774;
chunk__47029_47757 = G__47775;
count__47030_47758 = G__47776;
i__47031_47759 = G__47777;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq47024){
var self__4724__auto__ = this;
return self__4724__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47024));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__47032_47782 = cljs.core.seq(scripts);
var chunk__47033_47783 = null;
var count__47034_47784 = (0);
var i__47035_47785 = (0);
while(true){
if((i__47035_47785 < count__47034_47784)){
var vec__47043_47786 = chunk__47033_47783.cljs$core$IIndexed$_nth$arity$2(null,i__47035_47785);
var script_tag_47787 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47043_47786,(0),null);
var script_body_47788 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47043_47786,(1),null);
eval(script_body_47788);


var G__47789 = seq__47032_47782;
var G__47790 = chunk__47033_47783;
var G__47791 = count__47034_47784;
var G__47792 = (i__47035_47785 + (1));
seq__47032_47782 = G__47789;
chunk__47033_47783 = G__47790;
count__47034_47784 = G__47791;
i__47035_47785 = G__47792;
continue;
} else {
var temp__5735__auto___47793 = cljs.core.seq(seq__47032_47782);
if(temp__5735__auto___47793){
var seq__47032_47794__$1 = temp__5735__auto___47793;
if(cljs.core.chunked_seq_QMARK_(seq__47032_47794__$1)){
var c__4556__auto___47795 = cljs.core.chunk_first(seq__47032_47794__$1);
var G__47796 = cljs.core.chunk_rest(seq__47032_47794__$1);
var G__47797 = c__4556__auto___47795;
var G__47798 = cljs.core.count(c__4556__auto___47795);
var G__47799 = (0);
seq__47032_47782 = G__47796;
chunk__47033_47783 = G__47797;
count__47034_47784 = G__47798;
i__47035_47785 = G__47799;
continue;
} else {
var vec__47048_47800 = cljs.core.first(seq__47032_47794__$1);
var script_tag_47801 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47048_47800,(0),null);
var script_body_47802 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47048_47800,(1),null);
eval(script_body_47802);


var G__47803 = cljs.core.next(seq__47032_47794__$1);
var G__47804 = null;
var G__47805 = (0);
var G__47806 = (0);
seq__47032_47782 = G__47803;
chunk__47033_47783 = G__47804;
count__47034_47784 = G__47805;
i__47035_47785 = G__47806;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__47053){
var vec__47054 = p__47053;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47054,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47054,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__47069 = arguments.length;
switch (G__47069) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__47097 = cljs.core.seq(style_keys);
var chunk__47098 = null;
var count__47099 = (0);
var i__47100 = (0);
while(true){
if((i__47100 < count__47099)){
var it = chunk__47098.cljs$core$IIndexed$_nth$arity$2(null,i__47100);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__47821 = seq__47097;
var G__47822 = chunk__47098;
var G__47823 = count__47099;
var G__47824 = (i__47100 + (1));
seq__47097 = G__47821;
chunk__47098 = G__47822;
count__47099 = G__47823;
i__47100 = G__47824;
continue;
} else {
var temp__5735__auto__ = cljs.core.seq(seq__47097);
if(temp__5735__auto__){
var seq__47097__$1 = temp__5735__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47097__$1)){
var c__4556__auto__ = cljs.core.chunk_first(seq__47097__$1);
var G__47828 = cljs.core.chunk_rest(seq__47097__$1);
var G__47829 = c__4556__auto__;
var G__47830 = cljs.core.count(c__4556__auto__);
var G__47831 = (0);
seq__47097 = G__47828;
chunk__47098 = G__47829;
count__47099 = G__47830;
i__47100 = G__47831;
continue;
} else {
var it = cljs.core.first(seq__47097__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__47834 = cljs.core.next(seq__47097__$1);
var G__47835 = null;
var G__47836 = (0);
var G__47837 = (0);
seq__47097 = G__47834;
chunk__47098 = G__47835;
count__47099 = G__47836;
i__47100 = G__47837;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k47116,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__47125 = k47116;
var G__47125__$1 = (((G__47125 instanceof cljs.core.Keyword))?G__47125.fqn:null);
switch (G__47125__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k47116,else__4383__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__47129){
var vec__47130 = p__47129;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47130,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47130,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Coordinate{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47115){
var self__ = this;
var G__47115__$1 = this;
return (new cljs.core.RecordIter((0),G__47115__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47117,other47118){
var self__ = this;
var this47117__$1 = this;
return (((!((other47118 == null)))) && ((this47117__$1.constructor === other47118.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47117__$1.x,other47118.x)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47117__$1.y,other47118.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47117__$1.__extmap,other47118.__extmap)));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__47115){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__47152 = cljs.core.keyword_identical_QMARK_;
var expr__47153 = k__4388__auto__;
if(cljs.core.truth_((pred__47152.cljs$core$IFn$_invoke$arity$2 ? pred__47152.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__47153) : pred__47152.call(null,new cljs.core.Keyword(null,"x","x",2099068185),expr__47153)))){
return (new shadow.dom.Coordinate(G__47115,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__47152.cljs$core$IFn$_invoke$arity$2 ? pred__47152.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__47153) : pred__47152.call(null,new cljs.core.Keyword(null,"y","y",-1757859776),expr__47153)))){
return (new shadow.dom.Coordinate(self__.x,G__47115,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__47115),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__47115){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__47115,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__47120){
var extmap__4419__auto__ = (function (){var G__47167 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__47120,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__47120)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__47167);
} else {
return G__47167;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__47120),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__47120),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4380__auto__,k__4381__auto__){
var self__ = this;
var this__4380__auto____$1 = this;
return this__4380__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4381__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4382__auto__,k47190,else__4383__auto__){
var self__ = this;
var this__4382__auto____$1 = this;
var G__47202 = k47190;
var G__47202__$1 = (((G__47202 instanceof cljs.core.Keyword))?G__47202.fqn:null);
switch (G__47202__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k47190,else__4383__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4399__auto__,f__4400__auto__,init__4401__auto__){
var self__ = this;
var this__4399__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4402__auto__,p__47206){
var vec__47207 = p__47206;
var k__4403__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47207,(0),null);
var v__4404__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47207,(1),null);
return (f__4400__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4400__auto__.cljs$core$IFn$_invoke$arity$3(ret__4402__auto__,k__4403__auto__,v__4404__auto__) : f__4400__auto__.call(null,ret__4402__auto__,k__4403__auto__,v__4404__auto__));
}),init__4401__auto__,this__4399__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4394__auto__,writer__4395__auto__,opts__4396__auto__){
var self__ = this;
var this__4394__auto____$1 = this;
var pr_pair__4397__auto__ = (function (keyval__4398__auto__){
return cljs.core.pr_sequential_writer(writer__4395__auto__,cljs.core.pr_writer,""," ","",opts__4396__auto__,keyval__4398__auto__);
});
return cljs.core.pr_sequential_writer(writer__4395__auto__,pr_pair__4397__auto__,"#shadow.dom.Size{",", ","}",opts__4396__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47189){
var self__ = this;
var G__47189__$1 = this;
return (new cljs.core.RecordIter((0),G__47189__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4378__auto__){
var self__ = this;
var this__4378__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4375__auto__){
var self__ = this;
var this__4375__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4384__auto__){
var self__ = this;
var this__4384__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4376__auto__){
var self__ = this;
var this__4376__auto____$1 = this;
var h__4238__auto__ = self__.__hash;
if((!((h__4238__auto__ == null)))){
return h__4238__auto__;
} else {
var h__4238__auto____$1 = (function (coll__4377__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__4377__auto__));
})(this__4376__auto____$1);
(self__.__hash = h__4238__auto____$1);

return h__4238__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47191,other47192){
var self__ = this;
var this47191__$1 = this;
return (((!((other47192 == null)))) && ((this47191__$1.constructor === other47192.constructor)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47191__$1.w,other47192.w)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47191__$1.h,other47192.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47191__$1.__extmap,other47192.__extmap)));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4389__auto__,k__4390__auto__){
var self__ = this;
var this__4389__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__4390__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4389__auto____$1),self__.__meta),k__4390__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4390__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4387__auto__,k__4388__auto__,G__47189){
var self__ = this;
var this__4387__auto____$1 = this;
var pred__47224 = cljs.core.keyword_identical_QMARK_;
var expr__47225 = k__4388__auto__;
if(cljs.core.truth_((pred__47224.cljs$core$IFn$_invoke$arity$2 ? pred__47224.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__47225) : pred__47224.call(null,new cljs.core.Keyword(null,"w","w",354169001),expr__47225)))){
return (new shadow.dom.Size(G__47189,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__47224.cljs$core$IFn$_invoke$arity$2 ? pred__47224.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__47225) : pred__47224.call(null,new cljs.core.Keyword(null,"h","h",1109658740),expr__47225)))){
return (new shadow.dom.Size(self__.w,G__47189,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4388__auto__,G__47189),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4392__auto__){
var self__ = this;
var this__4392__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4379__auto__,G__47189){
var self__ = this;
var this__4379__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__47189,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4385__auto__,entry__4386__auto__){
var self__ = this;
var this__4385__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4386__auto__)){
return this__4385__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth(entry__4386__auto__,(0)),cljs.core._nth(entry__4386__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4385__auto____$1,entry__4386__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__4423__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__4423__auto__,writer__4424__auto__){
return cljs.core._write(writer__4424__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__47195){
var extmap__4419__auto__ = (function (){var G__47240 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__47195,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__47195)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__47240);
} else {
return G__47240;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__47195),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__47195),null,cljs.core.not_empty(extmap__4419__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__4610__auto__ = opts;
var l__4611__auto__ = a__4610__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__4611__auto__)){
var G__47913 = (i + (1));
var G__47914 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__47913;
ret = G__47914;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__47275){
var vec__47276 = p__47275;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47276,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47276,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__47282 = arguments.length;
switch (G__47282) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5733__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5733__auto__)){
var child = temp__5733__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__47923 = ps;
var G__47924 = (i + (1));
el__$1 = G__47923;
i = G__47924;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null,parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__47320 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47320,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47320,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47320,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__47325_47934 = cljs.core.seq(props);
var chunk__47326_47935 = null;
var count__47327_47936 = (0);
var i__47328_47937 = (0);
while(true){
if((i__47328_47937 < count__47327_47936)){
var vec__47343_47940 = chunk__47326_47935.cljs$core$IIndexed$_nth$arity$2(null,i__47328_47937);
var k_47941 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47343_47940,(0),null);
var v_47942 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47343_47940,(1),null);
el.setAttributeNS((function (){var temp__5735__auto__ = cljs.core.namespace(k_47941);
if(cljs.core.truth_(temp__5735__auto__)){
var ns = temp__5735__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_47941),v_47942);


var G__47943 = seq__47325_47934;
var G__47944 = chunk__47326_47935;
var G__47945 = count__47327_47936;
var G__47946 = (i__47328_47937 + (1));
seq__47325_47934 = G__47943;
chunk__47326_47935 = G__47944;
count__47327_47936 = G__47945;
i__47328_47937 = G__47946;
continue;
} else {
var temp__5735__auto___47947 = cljs.core.seq(seq__47325_47934);
if(temp__5735__auto___47947){
var seq__47325_47948__$1 = temp__5735__auto___47947;
if(cljs.core.chunked_seq_QMARK_(seq__47325_47948__$1)){
var c__4556__auto___47949 = cljs.core.chunk_first(seq__47325_47948__$1);
var G__47950 = cljs.core.chunk_rest(seq__47325_47948__$1);
var G__47951 = c__4556__auto___47949;
var G__47952 = cljs.core.count(c__4556__auto___47949);
var G__47953 = (0);
seq__47325_47934 = G__47950;
chunk__47326_47935 = G__47951;
count__47327_47936 = G__47952;
i__47328_47937 = G__47953;
continue;
} else {
var vec__47350_47954 = cljs.core.first(seq__47325_47948__$1);
var k_47955 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47350_47954,(0),null);
var v_47956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47350_47954,(1),null);
el.setAttributeNS((function (){var temp__5735__auto____$1 = cljs.core.namespace(k_47955);
if(cljs.core.truth_(temp__5735__auto____$1)){
var ns = temp__5735__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_47955),v_47956);


var G__47958 = cljs.core.next(seq__47325_47948__$1);
var G__47959 = null;
var G__47960 = (0);
var G__47961 = (0);
seq__47325_47934 = G__47958;
chunk__47326_47935 = G__47959;
count__47327_47936 = G__47960;
i__47328_47937 = G__47961;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null);
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__47354 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47354,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47354,(1),null);
var seq__47357_47962 = cljs.core.seq(node_children);
var chunk__47359_47963 = null;
var count__47360_47964 = (0);
var i__47361_47965 = (0);
while(true){
if((i__47361_47965 < count__47360_47964)){
var child_struct_47966 = chunk__47359_47963.cljs$core$IIndexed$_nth$arity$2(null,i__47361_47965);
if((!((child_struct_47966 == null)))){
if(typeof child_struct_47966 === 'string'){
var text_47967 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_47967),child_struct_47966].join(''));
} else {
var children_47968 = shadow.dom.svg_node(child_struct_47966);
if(cljs.core.seq_QMARK_(children_47968)){
var seq__47407_47969 = cljs.core.seq(children_47968);
var chunk__47409_47970 = null;
var count__47410_47971 = (0);
var i__47411_47972 = (0);
while(true){
if((i__47411_47972 < count__47410_47971)){
var child_47973 = chunk__47409_47970.cljs$core$IIndexed$_nth$arity$2(null,i__47411_47972);
if(cljs.core.truth_(child_47973)){
node.appendChild(child_47973);


var G__47974 = seq__47407_47969;
var G__47975 = chunk__47409_47970;
var G__47976 = count__47410_47971;
var G__47977 = (i__47411_47972 + (1));
seq__47407_47969 = G__47974;
chunk__47409_47970 = G__47975;
count__47410_47971 = G__47976;
i__47411_47972 = G__47977;
continue;
} else {
var G__47978 = seq__47407_47969;
var G__47979 = chunk__47409_47970;
var G__47980 = count__47410_47971;
var G__47981 = (i__47411_47972 + (1));
seq__47407_47969 = G__47978;
chunk__47409_47970 = G__47979;
count__47410_47971 = G__47980;
i__47411_47972 = G__47981;
continue;
}
} else {
var temp__5735__auto___47982 = cljs.core.seq(seq__47407_47969);
if(temp__5735__auto___47982){
var seq__47407_47983__$1 = temp__5735__auto___47982;
if(cljs.core.chunked_seq_QMARK_(seq__47407_47983__$1)){
var c__4556__auto___47984 = cljs.core.chunk_first(seq__47407_47983__$1);
var G__47985 = cljs.core.chunk_rest(seq__47407_47983__$1);
var G__47986 = c__4556__auto___47984;
var G__47987 = cljs.core.count(c__4556__auto___47984);
var G__47988 = (0);
seq__47407_47969 = G__47985;
chunk__47409_47970 = G__47986;
count__47410_47971 = G__47987;
i__47411_47972 = G__47988;
continue;
} else {
var child_47990 = cljs.core.first(seq__47407_47983__$1);
if(cljs.core.truth_(child_47990)){
node.appendChild(child_47990);


var G__47992 = cljs.core.next(seq__47407_47983__$1);
var G__47993 = null;
var G__47994 = (0);
var G__47995 = (0);
seq__47407_47969 = G__47992;
chunk__47409_47970 = G__47993;
count__47410_47971 = G__47994;
i__47411_47972 = G__47995;
continue;
} else {
var G__47996 = cljs.core.next(seq__47407_47983__$1);
var G__47997 = null;
var G__47998 = (0);
var G__47999 = (0);
seq__47407_47969 = G__47996;
chunk__47409_47970 = G__47997;
count__47410_47971 = G__47998;
i__47411_47972 = G__47999;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_47968);
}
}


var G__48000 = seq__47357_47962;
var G__48001 = chunk__47359_47963;
var G__48002 = count__47360_47964;
var G__48003 = (i__47361_47965 + (1));
seq__47357_47962 = G__48000;
chunk__47359_47963 = G__48001;
count__47360_47964 = G__48002;
i__47361_47965 = G__48003;
continue;
} else {
var G__48004 = seq__47357_47962;
var G__48005 = chunk__47359_47963;
var G__48006 = count__47360_47964;
var G__48007 = (i__47361_47965 + (1));
seq__47357_47962 = G__48004;
chunk__47359_47963 = G__48005;
count__47360_47964 = G__48006;
i__47361_47965 = G__48007;
continue;
}
} else {
var temp__5735__auto___48008 = cljs.core.seq(seq__47357_47962);
if(temp__5735__auto___48008){
var seq__47357_48009__$1 = temp__5735__auto___48008;
if(cljs.core.chunked_seq_QMARK_(seq__47357_48009__$1)){
var c__4556__auto___48010 = cljs.core.chunk_first(seq__47357_48009__$1);
var G__48011 = cljs.core.chunk_rest(seq__47357_48009__$1);
var G__48012 = c__4556__auto___48010;
var G__48013 = cljs.core.count(c__4556__auto___48010);
var G__48014 = (0);
seq__47357_47962 = G__48011;
chunk__47359_47963 = G__48012;
count__47360_47964 = G__48013;
i__47361_47965 = G__48014;
continue;
} else {
var child_struct_48015 = cljs.core.first(seq__47357_48009__$1);
if((!((child_struct_48015 == null)))){
if(typeof child_struct_48015 === 'string'){
var text_48016 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48016),child_struct_48015].join(''));
} else {
var children_48018 = shadow.dom.svg_node(child_struct_48015);
if(cljs.core.seq_QMARK_(children_48018)){
var seq__47426_48019 = cljs.core.seq(children_48018);
var chunk__47428_48020 = null;
var count__47429_48021 = (0);
var i__47430_48022 = (0);
while(true){
if((i__47430_48022 < count__47429_48021)){
var child_48023 = chunk__47428_48020.cljs$core$IIndexed$_nth$arity$2(null,i__47430_48022);
if(cljs.core.truth_(child_48023)){
node.appendChild(child_48023);


var G__48024 = seq__47426_48019;
var G__48025 = chunk__47428_48020;
var G__48026 = count__47429_48021;
var G__48027 = (i__47430_48022 + (1));
seq__47426_48019 = G__48024;
chunk__47428_48020 = G__48025;
count__47429_48021 = G__48026;
i__47430_48022 = G__48027;
continue;
} else {
var G__48028 = seq__47426_48019;
var G__48029 = chunk__47428_48020;
var G__48030 = count__47429_48021;
var G__48031 = (i__47430_48022 + (1));
seq__47426_48019 = G__48028;
chunk__47428_48020 = G__48029;
count__47429_48021 = G__48030;
i__47430_48022 = G__48031;
continue;
}
} else {
var temp__5735__auto___48032__$1 = cljs.core.seq(seq__47426_48019);
if(temp__5735__auto___48032__$1){
var seq__47426_48037__$1 = temp__5735__auto___48032__$1;
if(cljs.core.chunked_seq_QMARK_(seq__47426_48037__$1)){
var c__4556__auto___48038 = cljs.core.chunk_first(seq__47426_48037__$1);
var G__48039 = cljs.core.chunk_rest(seq__47426_48037__$1);
var G__48040 = c__4556__auto___48038;
var G__48041 = cljs.core.count(c__4556__auto___48038);
var G__48042 = (0);
seq__47426_48019 = G__48039;
chunk__47428_48020 = G__48040;
count__47429_48021 = G__48041;
i__47430_48022 = G__48042;
continue;
} else {
var child_48043 = cljs.core.first(seq__47426_48037__$1);
if(cljs.core.truth_(child_48043)){
node.appendChild(child_48043);


var G__48045 = cljs.core.next(seq__47426_48037__$1);
var G__48046 = null;
var G__48047 = (0);
var G__48048 = (0);
seq__47426_48019 = G__48045;
chunk__47428_48020 = G__48046;
count__47429_48021 = G__48047;
i__47430_48022 = G__48048;
continue;
} else {
var G__48049 = cljs.core.next(seq__47426_48037__$1);
var G__48050 = null;
var G__48051 = (0);
var G__48052 = (0);
seq__47426_48019 = G__48049;
chunk__47428_48020 = G__48050;
count__47429_48021 = G__48051;
i__47430_48022 = G__48052;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48018);
}
}


var G__48053 = cljs.core.next(seq__47357_48009__$1);
var G__48054 = null;
var G__48055 = (0);
var G__48056 = (0);
seq__47357_47962 = G__48053;
chunk__47359_47963 = G__48054;
count__47360_47964 = G__48055;
i__47361_47965 = G__48056;
continue;
} else {
var G__48057 = cljs.core.next(seq__47357_48009__$1);
var G__48058 = null;
var G__48059 = (0);
var G__48060 = (0);
seq__47357_47962 = G__48057;
chunk__47359_47963 = G__48058;
count__47360_47964 = G__48059;
i__47361_47965 = G__48060;
continue;
}
}
} else {
}
}
break;
}

return node;
});
goog.object.set(shadow.dom.SVGElement,"string",true);

goog.object.set(shadow.dom._to_svg,"string",(function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

goog.object.set(shadow.dom.SVGElement,"null",true);

goog.object.set(shadow.dom._to_svg,"null",(function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__4742__auto__ = [];
var len__4736__auto___48066 = arguments.length;
var i__4737__auto___48067 = (0);
while(true){
if((i__4737__auto___48067 < len__4736__auto___48066)){
args__4742__auto__.push((arguments[i__4737__auto___48067]));

var G__48068 = (i__4737__auto___48067 + (1));
i__4737__auto___48067 = G__48068;
continue;
} else {
}
break;
}

var argseq__4743__auto__ = ((((1) < args__4742__auto__.length))?(new cljs.core.IndexedSeq(args__4742__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4743__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq47454){
var G__47455 = cljs.core.first(seq47454);
var seq47454__$1 = cljs.core.next(seq47454);
var self__4723__auto__ = this;
return self__4723__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47455,seq47454__$1);
}));

/**
 * returns a channel for events on el
 * transform-fn should be a (fn [e el] some-val) where some-val will be put on the chan
 * once-or-cleanup handles the removal of the event handler
 * - true: remove after one event
 * - false: never removed
 * - chan: remove on msg/close
 */
shadow.dom.event_chan = (function shadow$dom$event_chan(var_args){
var G__47468 = arguments.length;
switch (G__47468) {
case 2:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$2 = (function (el,event){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,null,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$3 = (function (el,event,xf){
return shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4(el,event,xf,false);
}));

(shadow.dom.event_chan.cljs$core$IFn$_invoke$arity$4 = (function (el,event,xf,once_or_cleanup){
var buf = cljs.core.async.sliding_buffer((1));
var chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2(buf,xf);
var event_fn = (function shadow$dom$event_fn(e){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(chan,e);

if(once_or_cleanup === true){
shadow.dom.remove_event_handler(el,event,shadow$dom$event_fn);

return cljs.core.async.close_BANG_(chan);
} else {
return null;
}
});
shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(event),event_fn);

if(cljs.core.truth_((function (){var and__4115__auto__ = once_or_cleanup;
if(cljs.core.truth_(and__4115__auto__)){
return (!(once_or_cleanup === true));
} else {
return and__4115__auto__;
}
})())){
var c__43544__auto___48070 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__43545__auto__ = (function (){var switch__43297__auto__ = (function (state_47478){
var state_val_47479 = (state_47478[(1)]);
if((state_val_47479 === (1))){
var state_47478__$1 = state_47478;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_47478__$1,(2),once_or_cleanup);
} else {
if((state_val_47479 === (2))){
var inst_47474 = (state_47478[(2)]);
var inst_47476 = shadow.dom.remove_event_handler(el,event,event_fn);
var state_47478__$1 = (function (){var statearr_47485 = state_47478;
(statearr_47485[(7)] = inst_47474);

return statearr_47485;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_47478__$1,inst_47476);
} else {
return null;
}
}
});
return (function() {
var shadow$dom$state_machine__43298__auto__ = null;
var shadow$dom$state_machine__43298__auto____0 = (function (){
var statearr_47487 = [null,null,null,null,null,null,null,null];
(statearr_47487[(0)] = shadow$dom$state_machine__43298__auto__);

(statearr_47487[(1)] = (1));

return statearr_47487;
});
var shadow$dom$state_machine__43298__auto____1 = (function (state_47478){
while(true){
var ret_value__43299__auto__ = (function (){try{while(true){
var result__43300__auto__ = switch__43297__auto__(state_47478);
if(cljs.core.keyword_identical_QMARK_(result__43300__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__43300__auto__;
}
break;
}
}catch (e47488){var ex__43301__auto__ = e47488;
var statearr_47489_48071 = state_47478;
(statearr_47489_48071[(2)] = ex__43301__auto__);


if(cljs.core.seq((state_47478[(4)]))){
var statearr_47492_48072 = state_47478;
(statearr_47492_48072[(1)] = cljs.core.first((state_47478[(4)])));

} else {
throw ex__43301__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43299__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__48073 = state_47478;
state_47478 = G__48073;
continue;
} else {
return ret_value__43299__auto__;
}
break;
}
});
shadow$dom$state_machine__43298__auto__ = function(state_47478){
switch(arguments.length){
case 0:
return shadow$dom$state_machine__43298__auto____0.call(this);
case 1:
return shadow$dom$state_machine__43298__auto____1.call(this,state_47478);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
shadow$dom$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$0 = shadow$dom$state_machine__43298__auto____0;
shadow$dom$state_machine__43298__auto__.cljs$core$IFn$_invoke$arity$1 = shadow$dom$state_machine__43298__auto____1;
return shadow$dom$state_machine__43298__auto__;
})()
})();
var state__43546__auto__ = (function (){var statearr_47493 = f__43545__auto__();
(statearr_47493[(6)] = c__43544__auto___48070);

return statearr_47493;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__43546__auto__);
}));

} else {
}

return chan;
}));

(shadow.dom.event_chan.cljs$lang$maxFixedArity = 4);


//# sourceMappingURL=shadow.dom.js.map
