package jax;

import clojure.java.api.Clojure;
import clojure.lang.IFn;
import com.cycling74.max.Atom;
import com.cycling74.max.DataTypes;
import com.cycling74.max.MaxSystem;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.Server;

public class JaxRuntime extends com.cycling74.max.MaxObject {

    public interface JaxObject {
        void doBang();
        void doZap();
        void doInlet(int i);
        void doInlet(float f);
        void doInlet(String s);
        void doInlet(double d);
        void doInlet(String s, Atom[] args);
        void doOutlet(double value);
        void doOutlet(int value);
        void doOutlet(float value);
        void doOutlet(long value);
        void doOutlet(short value);
        void doOutlet(String value);
        void doOutlet(String s, Atom[] args);
        int getNREPLPort();
        int getJettyPort();
        Object getSente();
    }

    private static Object nrepl;
    private static Server jetty;
    private static Object sente;

    private IFn process = null;
    private void invokeProcess(String s, Object x) {
        if (process != null) {
            process.invoke(s, x);
        } else {
            MaxSystem.error("Cannot process message, jax not initialized");
        }
    }

    public JaxRuntime(Atom[] args) {
        IFn require = Clojure.var("clojure.core", "require");
        require.invoke(Clojure.read("jax.impl.system"));
        require.invoke(Clojure.read("jax.impl.nrepl"));
        require.invoke(Clojure.read("jax.impl.server"));
        require.invoke(Clojure.read("jax.impl.inlet"));
        JaxObject jax = jaxObject();
        IFn registerJax = Clojure.var("jax.impl.system", "register-jax");
        IFn setLoggerFactory = Clojure.var("jax.impl.system", "set-logger-factory!");
        setLoggerFactory.invoke();
        registerJax.invoke(jax);
        // These are our global singletons -- eg, things we don't want restarted each time the constructor gets called.
        if (nrepl == null) {
            IFn startRepl = Clojure.var("jax.impl.nrepl", "server");
            nrepl = startRepl.invoke();
        }
        if (sente == null) {
            IFn startSente = Clojure.var("jax.impl.server", "sente");
            sente = startSente.invoke();
        }
        if (jetty == null) {
            IFn startJetty = Clojure.var("jax.impl.server", "server");
            jetty = (Server) startJetty.invoke(sente);
        }
        if (process == null) {
            process = Clojure.var("jax.impl.inlet", "process!");
        }
        declareInlets(new int[]{DataTypes.ALL});
        declareOutlets(new int[]{DataTypes.ALL});
    }

    private JaxObject jaxObject() {
        return new JaxObject() {
            public int getNREPLPort() {
                IFn get = Clojure.var("clojure.core", "get");
                Object key = Clojure.read(":port");
                return (int) get.invoke(nrepl, key, -1);
            }
            public int getJettyPort() {
                Connector[] connectors = jetty.getConnectors();
                ServerConnector connector = (ServerConnector) connectors[0];
                return connector.getLocalPort();
            }
            public Object getSente() {
                return sente;
            }
            public void doBang() {
                bang();
            }
            public void doZap() { zap(); }
            public void doInlet(int i) { inlet(i); }
            public void doInlet(float f) { inlet(f); }
            public void doInlet(String s) { inlet(s); }
            public void doInlet(double d) { inlet(d); }
            public void doInlet(String s, Atom[] args) { anything(s, args); }
            public void doOutlet(double value) { outlet(0,value); }
            public void doOutlet(int value) { outlet(0, value); }
            public void doOutlet(float value) { outlet(0, value); }
            public void doOutlet(long value) { outlet(0, value); }
            public void doOutlet(short value) { outlet(0, value); }
            public void doOutlet(String value) { outlet(0, value); }
            public void doOutlet(String s, Atom[] args) {outlet(0, s, args); }
        };
    }

    public void bang() {
        outletBang(0);
    }

    public void inlet(int i) {
        invokeProcess("int", i);
    }

    public void inlet(float f) {
        invokeProcess("float", f);
    }

    public void inlet(String s) {
        invokeProcess("string", s);
    }

    public void inlet(double d) {
        invokeProcess("double", d);
    }

    public void anything(String s, Atom[] args) {
        invokeProcess(s, args);
    }
}