(ns jax.patcher.lang.scratchpad
  (:require [jax.patcher.lang.max :as j]))

(defn log
  [route abase]
  (j/log- nil (j// abase route)))

(defn lfo
  [route fratio]
  (->> (j/phasor- 1.0)
       (j/cos- nil)
       (j/snapshot- 2.0)))

(defn fenv
  "Basic frequency envelope adapted from https://www.youtube.com/watch?v=XDiciEiFhHc"
  [a d s r freq velocity]
  (let [gate (j/> 0.0 (j// 127.0 velocity))
        mult (j/* 1.0 gate freq)]
    (j/adsr- nil mult a d s r)))

(defn modulated-freq
  [envfreq lfo freq-mod]
  (->> (j/* 0.1 lfo)
       (j/* nil freq-mod)
       (j/+ nil envfreq)))

(defn modulated-amplitude
  [amp lfo amp-mod]
  (->> (j/atodb nil amp)
       (j/+ nil (j/* amp-mod amp-mod (j/* 60 lfo)))
       (j/dbtoa nil)))

(defn exp- [x]
  (j/pow- nil x x))

(defn master-scaled
  [aval ascale fscale aratio fratio]
  (let [a-exp (exp- (j/* nil ascale aratio))
        f-exp (exp- (j/* nil fscale fratio))]
    (->> (j/* nil a-exp f-exp)
         (j/* nil aval))))
