(ns jax.lang.impl.cljs.max
  (:require [jax.lang.max :as max]
            [jax.patcher :as patcher]
            [jax.lang.impl.protocols :as jax.proto]))

(defn map-arguments [this]
  (if (patcher/route? this)
    [this]
    (throw (ex-info (str "Invalid argument: " (pr-str this))
                    {:type :jax/syntax-error :argument this}))))

(defn map-inlet [this]
  [this])

(defn map-reference [this]
  (cond
    (patcher/route? this)
    [this]

    (patcher/object-set? this)
    [(patcher/ref this (get (meta this) :outlet 0))]

    (patcher/object? this)
    [(patcher/ref this (get (meta this) :outlet 0))]

    :else (throw (ex-info (str "Invalid reference " (pr-str this))
                          {:type :jax/syntax-error :reference this}))))

(defn list-arguments [this]
  (mapcat jax.proto/arguments this))

(defn list-inlet [this]
  (mapcat jax.proto/reference this))

(defn list-reference [this]
  (mapcat max/inlet this))

(extend-protocol jax.proto/IJaxLang
  boolean
  (arguments [this] [(if this 1 0)])
  (inlet [this] [(max/number (if this 1 0))])

  number
  (arguments [this] [this])
  (inlet [this] [(max/number this)])

  string
  (arguments [this] [this])
  (inlet [this] [(max/message this)])

  Keyword
  (arguments [this] [(patcher/route this)])
  (reference [_] [])
  (inlet [this] [(patcher/route this)])

  default
  (arguments [this]
    (throw (ex-info (str "Invalid argument: " (pr-str this))
                    {:type :jax/syntax-error :argument this})))
  (inlet [this]
    (throw (ex-info (str "Invalid inlet: " (pr-str this))
                    {:type :jax/syntax-error :inlet this})))
  (reference [this]
    (throw (ex-info (str "Invalid reference: " (pr-str this))
                    {:type :jax/syntax-error :reference this})))

  PersistentArrayMap
  (arguments [this] (map-arguments this))
  (inlet [this] (map-inlet this))
  (reference [this] (map-reference this))

  PersistentHashMap
  (arguments [this] (map-arguments this))
  (inlet [this] (map-inlet this))
  (reference [this] (map-reference this))

  PersistentVector
  (arguments [this] (list-arguments this))
  (reference [this] (list-reference this))
  (inlet [this] (list-inlet this))

  List
  (arguments [this] (list-arguments this))
  (reference [this] (list-reference this))
  (inlet [this] (list-inlet this))

  LazySeq
  (arguments [this] (list-arguments this))
  (reference [this] (list-reference this))
  (inlet [this] (list-inlet this))

  EmptyList
  (arguments [_] [])
  (reference [_] [])
  (inlet [_] []))