(ns jax.lang.impl.clj.max
  (:require [jax.lang.max :as max]
            [jax.patcher :as patcher]
            [jax.lang.impl.protocols :as jax.proto]
            [clojure.core.protocols :as p])
  (:import (clojure.lang Keyword)
           (jax.lang.max MaxFn)
           (java.net URI)
           (java.awt Desktop)
           (java.util Map List)))

(extend-type MaxFn
  jax.proto/IJaxFn
  (open-docs [this]
    (let [href (-> this p/datafy :meta :href)]
      (.browse (Desktop/getDesktop) (URI. (str "https://docs.cycling74.com" href))))))

(extend-protocol jax.proto/IJaxLang
  Boolean
  (arguments [this] [(if this 1 0)])
  (inlet [this] [(max/number (if this 1 0))])

  Double
  (arguments [this]
    (clojure.core/float this)
    [this])

  (inlet [this]
    (clojure.core/float this)
    [(max/float this)])

  Float
  (arguments [this] [this])
  (inlet [this] [(max/float this)])

  Short
  (arguments [this] [this])
  (inlet [this] [(max/number this)])

  Integer
  (arguments [this] [this])
  (inlet [this] [(max/int this)])

  Long
  (arguments [this] [this])
  (inlet [this] [(max/number this)])

  ^long
  (arguments [this] [this])
  (inlet [this] [(max/number this)])

  String
  (arguments [this] [this])
  (inlet [this] [(max/message this)])

  Keyword
  (arguments [this] [(patcher/route this)])
  (reference [_] [])
  (inlet [this] [(patcher/route this)])

  Object
  (arguments [this]
    (throw (ex-info (str "Invalid argument: " (pr-str this))
                    {:type :jax/syntax-error :argument this})))
  (inlet [this]
    (throw (ex-info (str "Invalid inlet: " (pr-str this))
                    {:type :jax/syntax-error :inlet this})))
  (reference [this]
    (throw (ex-info (str "Invalid reference: " (pr-str this))
                    {:type :jax/syntax-error :reference this})))

  Map
  (arguments [this]
    (if (patcher/route? this)
      [this]
      (throw (ex-info (str "Invalid argument: " (pr-str this))
                      {:type :jax/syntax-error :argument this}))))

  (inlet [this]
    [this])

  (reference [this]
    (cond
      (patcher/route? this)
      [this]

      (patcher/object-set? this)
      [(patcher/ref this (get (meta this) :outlet 0))]

      (patcher/object? this)
      [(patcher/ref this (get (meta this) :outlet 0))]

      :else (throw (ex-info (str "Invalid reference " (pr-str this))
                            {:type :jax/syntax-error :reference this}))))

  List
  (arguments [this] (mapcat jax.proto/arguments this))
  (reference [this] (mapcat jax.proto/reference this))
  (inlet [this] (mapcat jax.proto/inlet this)))