(ns jax.lang.scratchpad
  (:require [jax.lang.max :as m]))

(defn log
  [route abase]
  (m/log- nil (m// abase route)))

(defn lfo
  [route fratio]
  (->> (m/phasor- 1.0)
       (m/cos- nil)
       (m/snapshot- 2.0)))

(defn fenv
  "Basic frequency envelope adapted from https://www.youtube.com/watch?v=XDiciEiFhHc"
  [a d s r freq velocity]
  (let [gate (m/> 0.0 (m// 127.0 velocity))
        mult (m/* 1.0 gate freq)]
    (m/adsr- nil mult a d s r)))

(defn modulated-freq
  [envfreq lfo freq-mod]
  (->> (m/* 0.1 lfo)
       (m/* nil freq-mod)
       (m/+ nil envfreq)))

(defn modulated-amplitude
  [amp lfo amp-mod]
  (->> (m/atodb nil amp)
       (m/+ nil (m/* amp-mod amp-mod (m/* 60 lfo)))
       (m/dbtoa nil)))

(defn exp- [x]
  (m/pow- nil x x))

(defn master-scaled
  [aval ascale fscale aratio fratio]
  (let [a-exp (exp- (m/* nil ascale aratio))
        f-exp (exp- (m/* nil fscale fratio))]
    (->> (m/* nil a-exp f-exp)
         (m/* nil aval))))
