(ns peony.coll
  (:require [peony.conv :as c])
  (:import [com.mongodb DB DBObject DBCollection WriteConcern]
           org.bson.types.ObjectId))

(def ^:dynamic ^WriteConcern *wc* WriteConcern/ACKNOWLEDGED)

(defn ++++ [col doc]
  (let [_id# {:_id (c/c2o nil)}
        doc# (c/c2m (merge _id# doc))]
    (.insert col doc# *wc*)
    (c/c2m doc#)))

(defn ---- [col qry]
  (let [qry# (c/c2m qry)]
    (c/c2m (.findAndRemove col qry#))))

(defn --id [col id]
  (---- col {:_id (c/c2o id)}))

(defn ???? [col qry]
  (let [qry# (c/c2m qry)]
    (with-open [cur (.find col qry#)]
      (map (fn [x] (c/c2m x)) cur))))

(defn ??id [col id]
  (first (???? col {:_id (c/c2o id)})))

(defn ====  [col qry doc]
  (let [qry# (c/c2m qry)
        doc# (c/c2m doc)
        _id# (:_id (c/m2c (.findAndModify col qry# doc#)))]  
    (??id col _id#)))

(defn ==id [col id doc]
  (==== col {:_id (c/c2o id)} doc))


