(ns peach.core
  (:require [peach.util :as u]))

(def ^:dynamic *db* {})

(defn open [url]
  (let [uri# (u/uri_ url)
       [host port] (u/addr uri#)
       [user pass] (u/auth uri#)
       [conf tout] (u/conf)]
    (u/pool conf host port tout pass)))

(defn ==== [k v] (u/exec *db* (fn [j] (.set j k v))))

(defn ???? [k] 
  (u/exec *db* (fn [j] (.get j k))))

(defmacro >>>> [db & body] 
  `(do (let [db# ~db] (binding [*db* db#] ~@body))))
