(ns lotus.util
  (:require [clout.core :as cc]))

(defn- res [msg ids req] {:status 200 :body {:msg msg :ids ids}})
(defn- c [ids req] (res "c" ids req))
(defn- q [ids req] (res "q" ids req))
(defn- r [ids req] (res "r" ids req))
(defn- u [ids req] (res "u" ids req))
(defn- d [ids req] (res "d" ids req))

(defn me 
  ([] (me c q r u d))
  ([c q r u d] {:c c :q q :r r :u u :d d}))

(defn- auto-load "auto load resource module"
  [resource prefix]
  (let [s (str prefix "." resource)]
    (try (require (symbol s)) (catch Exception e nil))
    (try ((ns-resolve (symbol s) 'me)) (catch Exception e nil))))

(defn- dump [s]
  (if (nil? s ) "" s))

(defn parse "parse the resources" 
  [resources prefix]
  (let [name# (first resources )
        sons# (second resources )
        dump# (dump (second (rest resources)))
        load# (auto-load name# prefix)]
    {:self {:match (format "%s/%s" dump# name#)       
            :funcs {:post (:c load#) :get (:q load#)}}
     :unit {:match (format "%s/%s/:%s-id" dump# name# name#) 
            :funcs {:get (:r load#) :put (:u load#) :delete (:d load#)}}
     :sons (map #(parse % prefix) sons# )}))

(defn- match-item [mom req res sub]
  (cc/route-matches (str mom (:match (sub res))) req))

(defn match [mom req res]
  (if-let [ids (match-item mom req res :self)]   
    {:ids ids :fun ((:request-method req) (:funcs (:self res)))}
    (if-let [ids (match-item mom req res :unit)]
     {:ids ids :fun ((:request-method req) (:funcs (:unit res)))}
      (some #(match (str mom (:match (:unit res))) req %) (:sons res)))))

(defn run-matched [req res]
  (when-let [matched# (match "" req res)]
    (when-let [fun# (:fun matched#)]
      (fun# (:ids matched#) req))))


