(ns lotus.file
  (:require [clojure.xml :as x]
            [clojure.data.json :as j]
            [lotus.util :as u]))

(defn- trans-xml "translate xml to list" 
  [resource]
   (list 
     (name (:tag resource)) 
     (map #(trans-xml %) (:content resource)) 
     (:dump (:attrs resource))))

(defn- trans-json "translate json to list"
  [resource]
  (list
    (:name resource)
    (map #(trans-json %) (:sons resource))
    (:dump resource)))

(defn load-xml "load resource tree from xml file"
  [file]
  (let [loaded (x/parse file)
        resource (trans-xml (first (:content loaded)))
        prefix (:prefix (:attrs loaded))]
    (u/parse resource prefix)))

(defn load-json "load resource tree from json file"
  [file]
  (let [loaded (j/read-str (slurp file) :key-fn keyword)
        resource (trans-json (:content loaded))
        prefix (:prefix loaded)]
    (u/parse resource prefix)))


