(ns dos-installer.main
  (:gen-class)
  (:require [clojure.pprint :as pprint]
            [dos-installer.docker :as docker]
            [dos-installer.executable :as executable]
            [dos-installer.installer :as installer]
            [dos-installer.shell-script :as shell.script]
            [dos-installer.utils.deps :as utils.deps]
            [dos-installer.utils.files :as utils.files]))

(defn fix-babashka-pprint-exception
  []
  (prefer-method pprint/simple-dispatch clojure.lang.IPersistentMap clojure.lang.IDeref))

(defn -main [& args]
  (try
    (let [user-dir (System/getProperty "user.dir")
          deps (utils.deps/edn)]
      (fix-babashka-pprint-exception)
      (utils.files/clean-resources-dos user-dir)
      (executable/build-packr-json deps user-dir)
      (docker/build-dockerfile user-dir)
      (shell.script/build-copy-executable-sh user-dir)
      (shell.script/build-copy-installer-sh user-dir)
      (installer/build-iss deps user-dir)
      (docker/build-cmd deps)
      (docker/get-executable-out deps)
      (docker/get-installer-out deps))
    (catch Throwable t
      (println "Error! " t))
    (finally
      (shutdown-agents)
      (when (utils.deps/clear-resources-dos? (utils.deps/edn))
        (utils.files/clean-resources-dos (System/getProperty "user.dir"))))))
