/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.html;

import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.cyberneko.html.HTMLAugmentations;
import org.cyberneko.html.HTMLComponent;
import org.cyberneko.html.HTMLElements;
import org.cyberneko.html.HTMLErrorReporter;
import org.cyberneko.html.HTMLEventInfo;
import org.cyberneko.html.HTMLTagBalancingListener;
import org.cyberneko.html.LostText;
import org.cyberneko.html.xercesbridge.XercesBridge;

public class HTMLTagBalancer
implements XMLDocumentFilter,
HTMLComponent {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    protected static final String REPORT_ERRORS = "http://cyberneko.org/html/features/report-errors";
    protected static final String DOCUMENT_FRAGMENT_DEPRECATED = "http://cyberneko.org/html/features/document-fragment";
    protected static final String DOCUMENT_FRAGMENT = "http://cyberneko.org/html/features/balance-tags/document-fragment";
    protected static final String IGNORE_OUTSIDE_CONTENT = "http://cyberneko.org/html/features/balance-tags/ignore-outside-content";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespaces", "http://cyberneko.org/html/features/augmentations", "http://cyberneko.org/html/features/report-errors", "http://cyberneko.org/html/features/document-fragment", "http://cyberneko.org/html/features/balance-tags/document-fragment", "http://cyberneko.org/html/features/balance-tags/ignore-outside-content"};
    private static final Boolean[] RECOGNIZED_FEATURES_DEFAULTS = new Boolean[]{null, null, null, null, Boolean.FALSE, Boolean.FALSE};
    protected static final String NAMES_ELEMS = "http://cyberneko.org/html/properties/names/elems";
    protected static final String NAMES_ATTRS = "http://cyberneko.org/html/properties/names/attrs";
    protected static final String ERROR_REPORTER = "http://cyberneko.org/html/properties/error-reporter";
    public static final String FRAGMENT_CONTEXT_STACK = "http://cyberneko.org/html/properties/balance-tags/fragment-context-stack";
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://cyberneko.org/html/properties/names/elems", "http://cyberneko.org/html/properties/names/attrs", "http://cyberneko.org/html/properties/error-reporter", "http://cyberneko.org/html/properties/balance-tags/fragment-context-stack"};
    private static final Object[] RECOGNIZED_PROPERTIES_DEFAULTS = new Object[]{null, null, null, null};
    protected static final short NAMES_NO_CHANGE = 0;
    protected static final short NAMES_MATCH = 0;
    protected static final short NAMES_UPPERCASE = 1;
    protected static final short NAMES_LOWERCASE = 2;
    protected static final HTMLEventInfo SYNTHESIZED_ITEM = new HTMLEventInfo.SynthesizedItem();
    protected boolean fNamespaces;
    protected boolean fAugmentations;
    protected boolean fReportErrors;
    protected boolean fDocumentFragment;
    protected boolean fIgnoreOutsideContent;
    protected short fNamesElems;
    protected short fNamesAttrs;
    protected HTMLErrorReporter fErrorReporter;
    protected XMLDocumentSource fDocumentSource;
    protected XMLDocumentHandler fDocumentHandler;
    protected final InfoStack fElementStack = new InfoStack();
    protected final InfoStack fInlineStack = new InfoStack();
    protected boolean fSeenAnything;
    protected boolean fSeenDoctype;
    protected boolean fSeenRootElement;
    protected boolean fSeenRootElementEnd;
    protected boolean fSeenHeadElement;
    protected boolean fSeenBodyElement;
    protected boolean fOpenedForm;
    private final QName fQName = new QName();
    private final XMLAttributes fEmptyAttrs = new XMLAttributesImpl();
    private final HTMLAugmentations fInfosetAugs = new HTMLAugmentations();
    protected HTMLTagBalancingListener tagBalancingListener;
    private LostText lostText_ = new LostText();
    private boolean forcedStartElement_ = false;
    private boolean forcedEndElement_ = false;
    private QName[] fragmentContextStack_ = null;
    private int fragmentContextStackSize_ = 0;
    private List endElementsBuffer_ = new ArrayList();

    public Boolean getFeatureDefault(String string) {
        int n = RECOGNIZED_FEATURES != null ? RECOGNIZED_FEATURES.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!RECOGNIZED_FEATURES[i].equals(string)) continue;
            return RECOGNIZED_FEATURES_DEFAULTS[i];
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        int n = RECOGNIZED_PROPERTIES != null ? RECOGNIZED_PROPERTIES.length : 0;
        for (int i = 0; i < n; ++i) {
            if (!RECOGNIZED_PROPERTIES[i].equals(string)) continue;
            return RECOGNIZED_PROPERTIES_DEFAULTS[i];
        }
        return null;
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public String[] getRecognizedProperties() {
        return RECOGNIZED_PROPERTIES;
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        this.fAugmentations = xMLComponentManager.getFeature(AUGMENTATIONS);
        this.fReportErrors = xMLComponentManager.getFeature(REPORT_ERRORS);
        this.fDocumentFragment = xMLComponentManager.getFeature(DOCUMENT_FRAGMENT) || xMLComponentManager.getFeature(DOCUMENT_FRAGMENT_DEPRECATED);
        this.fIgnoreOutsideContent = xMLComponentManager.getFeature(IGNORE_OUTSIDE_CONTENT);
        this.fNamesElems = HTMLTagBalancer.getNamesValue(String.valueOf(xMLComponentManager.getProperty(NAMES_ELEMS)));
        this.fNamesAttrs = HTMLTagBalancer.getNamesValue(String.valueOf(xMLComponentManager.getProperty(NAMES_ATTRS)));
        this.fErrorReporter = (HTMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        this.fragmentContextStack_ = (QName[])xMLComponentManager.getProperty(FRAGMENT_CONTEXT_STACK);
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
        if (string.equals(AUGMENTATIONS)) {
            this.fAugmentations = bl;
            return;
        }
        if (string.equals(REPORT_ERRORS)) {
            this.fReportErrors = bl;
            return;
        }
        if (string.equals(IGNORE_OUTSIDE_CONTENT)) {
            this.fIgnoreOutsideContent = bl;
            return;
        }
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.equals(NAMES_ELEMS)) {
            this.fNamesElems = HTMLTagBalancer.getNamesValue(String.valueOf(object));
            return;
        }
        if (string.equals(NAMES_ATTRS)) {
            this.fNamesAttrs = HTMLTagBalancer.getNamesValue(String.valueOf(object));
            return;
        }
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fElementStack.top = 0;
        if (this.fragmentContextStack_ != null) {
            this.fragmentContextStackSize_ = this.fragmentContextStack_.length;
            for (int i = 0; i < this.fragmentContextStack_.length; ++i) {
                QName qName = this.fragmentContextStack_[i];
                HTMLElements.Element element = HTMLElements.getElement(qName.localpart);
                this.fElementStack.push(new Info(element, qName));
            }
        } else {
            this.fragmentContextStackSize_ = 0;
        }
        this.fSeenAnything = false;
        this.fSeenDoctype = false;
        this.fSeenRootElement = false;
        this.fSeenRootElementEnd = false;
        this.fSeenHeadElement = false;
        this.fSeenBodyElement = false;
        if (this.fDocumentHandler != null) {
            XercesBridge.getInstance().XMLDocumentHandler_startDocument(this.fDocumentHandler, xMLLocator, string, namespaceContext, augmentations);
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (!this.fSeenAnything && this.fDocumentHandler != null) {
            this.fDocumentHandler.xmlDecl(string, string2, string3, augmentations);
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        this.fSeenAnything = true;
        if (this.fReportErrors) {
            if (this.fSeenRootElement) {
                this.fErrorReporter.reportError("HTML2010", null);
            } else if (this.fSeenDoctype) {
                this.fErrorReporter.reportError("HTML2011", null);
            }
        }
        if (!this.fSeenRootElement && !this.fSeenDoctype) {
            this.fSeenDoctype = true;
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.doctypeDecl(string, string2, string3, augmentations);
            }
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        this.fIgnoreOutsideContent = true;
        this.consumeBufferedEndElements();
        if (!this.fSeenRootElement && !this.fDocumentFragment) {
            if (this.fReportErrors) {
                this.fErrorReporter.reportError("HTML2000", null);
            }
            if (this.fDocumentHandler != null) {
                this.fSeenRootElementEnd = false;
                this.forceStartBody();
                String string = HTMLTagBalancer.modifyName("body", this.fNamesElems);
                this.fQName.setValues(null, string, string, null);
                this.callEndElement(this.fQName, this.synthesizedAugs());
                String string2 = HTMLTagBalancer.modifyName("html", this.fNamesElems);
                this.fQName.setValues(null, string2, string2, null);
                this.callEndElement(this.fQName, this.synthesizedAugs());
            }
        } else {
            int n = this.fElementStack.top - this.fragmentContextStackSize_;
            for (int i = 0; i < n; ++i) {
                Info info = this.fElementStack.pop();
                if (this.fReportErrors) {
                    String string = info.qname.rawname;
                    this.fErrorReporter.reportWarning("HTML2001", new Object[]{string});
                }
                if (this.fDocumentHandler == null) continue;
                this.callEndElement(info.qname, this.synthesizedAugs());
            }
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endDocument(augmentations);
        }
    }

    private void consumeBufferedEndElements() {
        ArrayList arrayList = new ArrayList(this.endElementsBuffer_);
        this.endElementsBuffer_.clear();
        for (int i = 0; i < arrayList.size(); ++i) {
            ElementEntry elementEntry = (ElementEntry)arrayList.get(i);
            this.forcedEndElement_ = true;
            this.endElement(elementEntry.name_, elementEntry.augs_);
        }
        this.endElementsBuffer_.clear();
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fSeenAnything = true;
        this.consumeEarlyTextIfNeeded();
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.comment(xMLString, augmentations);
        }
    }

    private void consumeEarlyTextIfNeeded() {
        if (!this.lostText_.isEmpty()) {
            if (!this.fSeenBodyElement) {
                this.forceStartBody();
            }
            this.lostText_.refeed((XMLDocumentHandler)this);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.fSeenAnything = true;
        this.consumeEarlyTextIfNeeded();
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.processingInstruction(string, xMLString, augmentations);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        int n;
        Info info;
        int n2;
        Object object;
        this.fSeenAnything = true;
        boolean bl = this.forcedStartElement_;
        this.forcedStartElement_ = false;
        if (this.fSeenRootElementEnd) {
            this.notifyDiscardedStartElement(qName, xMLAttributes, augmentations);
            return;
        }
        HTMLElements.Element element = this.getElement(qName);
        short s = element.code;
        if (bl && (s == 101 || s == 91)) {
            return;
        }
        if (this.fSeenRootElement && s == 46) {
            this.notifyDiscardedStartElement(qName, xMLAttributes, augmentations);
            return;
        }
        if (s == 44) {
            if (this.fSeenHeadElement) {
                this.notifyDiscardedStartElement(qName, xMLAttributes, augmentations);
                return;
            }
            this.fSeenHeadElement = true;
        } else if (s == 37) {
            this.consumeBufferedEndElements();
        } else if (s == 14) {
            if (!this.fSeenHeadElement) {
                object = this.createQName("head");
                this.forceStartElement((QName)object, null, this.synthesizedAugs());
                this.endElement((QName)object, this.synthesizedAugs());
            }
            this.consumeBufferedEndElements();
            if (this.fSeenBodyElement) {
                this.notifyDiscardedStartElement(qName, xMLAttributes, augmentations);
                return;
            }
            this.fSeenBodyElement = true;
        } else if (s == 35) {
            if (this.fOpenedForm) {
                this.notifyDiscardedStartElement(qName, xMLAttributes, augmentations);
                return;
            }
            this.fOpenedForm = true;
        } else if (s == 117) {
            this.consumeBufferedEndElements();
        }
        if (element.parent != null) {
            if (!this.fSeenRootElement && !this.fDocumentFragment) {
                String string;
                object = element.parent[0].name;
                object = HTMLTagBalancer.modifyName((String)object, this.fNamesElems);
                if (this.fReportErrors) {
                    string = qName.rawname;
                    this.fErrorReporter.reportWarning("HTML2002", new Object[]{string, object});
                }
                if ((n2 = (int)(this.forceStartElement((QName)(string = new QName(null, (String)object, (String)object, null)), null, this.synthesizedAugs()) ? 1 : 0)) == 0) {
                    if (!bl) {
                        this.notifyDiscardedStartElement(qName, xMLAttributes, augmentations);
                    }
                    return;
                }
            } else {
                int n3;
                object = element.parent[0];
                if ((object.code != 44 || !this.fSeenBodyElement && !this.fDocumentFragment) && (n3 = this.getParentDepth(element.parent, element.bounds)) == -1) {
                    String string = HTMLTagBalancer.modifyName(object.name, this.fNamesElems);
                    info = new QName(null, string, string, null);
                    if (this.fReportErrors) {
                        String string2 = qName.rawname;
                        this.fErrorReporter.reportWarning("HTML2004", new Object[]{string2, string});
                    }
                    if ((n = this.forceStartElement((QName)info, null, this.synthesizedAugs())) == 0) {
                        if (!bl) {
                            this.notifyDiscardedStartElement(qName, xMLAttributes, augmentations);
                        }
                        return;
                    }
                }
            }
        }
        int n4 = 0;
        if (element.flags == 0) {
            int n5 = this.fElementStack.top;
            this.fInlineStack.top = 0;
            for (n2 = n5 - 1; n2 >= 0; --n2) {
                info = this.fElementStack.data[n2];
                if (!info.element.isInline()) break;
                this.fInlineStack.push(info);
                this.endElement(info.qname, this.synthesizedAugs());
            }
            n4 = this.fInlineStack.top;
        }
        if (this.fElementStack.top > 1 && this.fElementStack.peek().element.code == 90 || this.fElementStack.top > 2 && this.fElementStack.data[this.fElementStack.top - 2].element.code == 44) {
            Info info2 = this.fElementStack.pop();
            if (this.fDocumentHandler != null) {
                this.callEndElement(info2.qname, this.synthesizedAugs());
            }
        }
        if (element.closes != null) {
            int n6 = this.fElementStack.top;
            for (n2 = n6 - 1; n2 >= 0; --n2) {
                info = this.fElementStack.data[n2];
                if (element.closes(info.element.code)) {
                    if (this.fReportErrors) {
                        String string = qName.rawname;
                        String string3 = info.qname.rawname;
                        this.fErrorReporter.reportWarning("HTML2005", new Object[]{string, string3});
                    }
                    for (n = n6 - 1; n >= n2; --n) {
                        info = this.fElementStack.pop();
                        if (this.fDocumentHandler == null) continue;
                        this.callEndElement(info.qname, this.synthesizedAugs());
                    }
                    n6 = n2;
                    continue;
                }
                if (!element.nestable || !info.element.isBlock() && !element.isParent(info.element)) {
                    continue;
                }
                break;
            }
        } else if (s == 101) {
            for (int i = this.fElementStack.top - 1; i >= 0; --i) {
                Info info3 = this.fElementStack.data[i];
                if (info3.element.isInline()) {
                    this.endElement(info3.qname, this.synthesizedAugs());
                    continue;
                }
                break;
            }
        }
        this.fSeenRootElement = true;
        if (element != null && element.isEmpty()) {
            if (xMLAttributes == null) {
                xMLAttributes = this.emptyAttributes();
            }
            if (this.fDocumentHandler != null) {
                this.fDocumentHandler.emptyElement(qName, xMLAttributes, augmentations);
            }
        } else {
            boolean bl2 = element != null && element.isInline();
            this.fElementStack.push(new Info(element, qName, (XMLAttributes)(bl2 ? xMLAttributes : null)));
            if (xMLAttributes == null) {
                xMLAttributes = this.emptyAttributes();
            }
            if (this.fDocumentHandler != null) {
                this.callStartElement(qName, xMLAttributes, augmentations);
            }
        }
        for (int i = 0; i < n4; ++i) {
            Info info4 = this.fInlineStack.pop();
            this.forceStartElement(info4.qname, info4.attributes, this.synthesizedAugs());
        }
        if (s == 14) {
            this.lostText_.refeed((XMLDocumentHandler)this);
        }
    }

    private boolean forceStartElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.forcedStartElement_ = true;
        this.startElement(qName, xMLAttributes, augmentations);
        return this.fElementStack.top > 0 && qName.equals((Object)this.fElementStack.peek().qname);
    }

    private QName createQName(String string) {
        string = HTMLTagBalancer.modifyName(string, this.fNamesElems);
        return new QName(null, string, string, "http://www.w3.org/1999/xhtml");
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.startElement(qName, xMLAttributes, augmentations);
        HTMLElements.Element element = this.getElement(qName);
        if (element.isEmpty() || element.code == 117) {
            this.endElement(qName, augmentations);
        }
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        this.fSeenAnything = true;
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (!this.fDocumentFragment) {
            boolean bl;
            boolean bl2 = bl = !this.fSeenRootElement;
            if (!bl) {
                Info info = this.fElementStack.peek();
                if (info.element.code == 44 || info.element.code == 46) {
                    String string3 = HTMLTagBalancer.modifyName("head", this.fNamesElems);
                    String string4 = HTMLTagBalancer.modifyName("body", this.fNamesElems);
                    if (this.fReportErrors) {
                        this.fErrorReporter.reportWarning("HTML2009", new Object[]{string3, string4});
                    }
                    this.fQName.setValues(null, string3, string3, null);
                    this.endElement(this.fQName, this.synthesizedAugs());
                    bl = true;
                }
            }
            if (bl) {
                this.forceStartBody();
            }
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    private void forceStartBody() {
        QName qName = this.createQName("body");
        if (this.fReportErrors) {
            this.fErrorReporter.reportWarning("HTML2006", new Object[]{qName.localpart});
        }
        this.forceStartElement(qName, null, this.synthesizedAugs());
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        this.fSeenAnything = true;
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.textDecl(string, string2, augmentations);
        }
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endGeneralEntity(string, augmentations);
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        this.fSeenAnything = true;
        this.consumeEarlyTextIfNeeded();
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startCDATA(augmentations);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endCDATA(augmentations);
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (this.fElementStack.top == 0 && !this.fDocumentFragment) {
            this.lostText_.add(xMLString, augmentations);
            return;
        }
        boolean bl = true;
        for (int i = 0; i < xMLString.length; ++i) {
            if (Character.isWhitespace(xMLString.ch[xMLString.offset + i])) continue;
            bl = false;
            break;
        }
        if (!this.fDocumentFragment) {
            if (!this.fSeenRootElement) {
                if (bl) {
                    return;
                }
                this.forceStartBody();
            }
            if (bl && (this.fElementStack.top < 2 || this.endElementsBuffer_.size() == 1)) {
                return;
            }
            if (!bl) {
                Info info = this.fElementStack.peek();
                if (info.element.code == 44 || info.element.code == 46) {
                    String string = HTMLTagBalancer.modifyName("head", this.fNamesElems);
                    String string2 = HTMLTagBalancer.modifyName("body", this.fNamesElems);
                    if (this.fReportErrors) {
                        this.fErrorReporter.reportWarning("HTML2009", new Object[]{string, string2});
                    }
                    this.forceStartBody();
                }
            }
        }
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.characters(xMLString, augmentations);
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        this.characters(xMLString, augmentations);
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        Object object;
        Object object2;
        int n;
        int n2;
        boolean bl = this.forcedEndElement_;
        if (this.fSeenRootElementEnd) {
            this.notifyDiscardedEndElement(qName, augmentations);
            return;
        }
        HTMLElements.Element element = this.getElement(qName);
        if (!(this.fIgnoreOutsideContent || element.code != 14 && element.code != 46)) {
            this.endElementsBuffer_.add(new ElementEntry(qName, augmentations));
            return;
        }
        if (element.code == 46) {
            this.fSeenRootElementEnd = true;
        } else if (element.code == 35) {
            this.fOpenedForm = false;
        } else if (element.code == 44 && !bl) {
            this.endElementsBuffer_.add(new ElementEntry(qName, augmentations));
            return;
        }
        int n3 = this.getElementDepth(element);
        if (n3 == -1) {
            if (element.code == 77) {
                this.forceStartElement(qName, this.emptyAttributes(), this.synthesizedAugs());
                this.endElement(qName, augmentations);
            } else if (!element.isEmpty()) {
                this.notifyDiscardedEndElement(qName, augmentations);
            }
            return;
        }
        if (n3 > 1 && element.isInline()) {
            n2 = this.fElementStack.top;
            this.fInlineStack.top = 0;
            for (n = 0; n < n3 - 1; ++n) {
                object2 = this.fElementStack.data[n2 - n - 1];
                object = ((Info)object2).element;
                if (!((HTMLElements.Element)object).isInline() && ((HTMLElements.Element)object).code != 34) continue;
                this.fInlineStack.push((Info)object2);
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            Info info = this.fElementStack.pop();
            if (this.fReportErrors && n2 < n3 - 1) {
                object2 = HTMLTagBalancer.modifyName(qName.rawname, this.fNamesElems);
                object = info.qname.rawname;
                this.fErrorReporter.reportWarning("HTML2007", new Object[]{object2, object});
            }
            if (this.fDocumentHandler == null) continue;
            this.callEndElement(info.qname, n2 < n3 - 1 ? this.synthesizedAugs() : augmentations);
        }
        if (n3 > 1) {
            n2 = this.fInlineStack.top;
            for (n = 0; n < n2; ++n) {
                object2 = this.fInlineStack.pop();
                object = ((Info)object2).attributes;
                if (this.fReportErrors) {
                    String string = ((Info)object2).qname.rawname;
                    this.fErrorReporter.reportWarning("HTML2008", new Object[]{string});
                }
                this.forceStartElement(((Info)object2).qname, (XMLAttributes)object, this.synthesizedAugs());
            }
        }
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.fDocumentSource = xMLDocumentSource;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        this.startDocument(xMLLocator, string, null, augmentations);
    }

    public void startPrefixMapping(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (this.fDocumentHandler != null) {
            XercesBridge.getInstance().XMLDocumentHandler_startPrefixMapping(this.fDocumentHandler, string, string2, augmentations);
        }
    }

    public void endPrefixMapping(String string, Augmentations augmentations) throws XNIException {
        if (this.fSeenRootElementEnd) {
            return;
        }
        if (this.fDocumentHandler != null) {
            XercesBridge.getInstance().XMLDocumentHandler_endPrefixMapping(this.fDocumentHandler, string, augmentations);
        }
    }

    protected HTMLElements.Element getElement(QName qName) {
        int n;
        String string = qName.rawname;
        if (this.fNamespaces && "http://www.w3.org/1999/xhtml".equals(qName.uri) && (n = string.indexOf(58)) != -1) {
            string = string.substring(n + 1);
        }
        return HTMLElements.getElement(string);
    }

    protected final void callStartElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.fDocumentHandler.startElement(qName, xMLAttributes, augmentations);
    }

    protected final void callEndElement(QName qName, Augmentations augmentations) throws XNIException {
        this.fDocumentHandler.endElement(qName, augmentations);
    }

    protected final int getElementDepth(HTMLElements.Element element) {
        boolean bl = element.isContainer();
        int n = -1;
        for (int i = this.fElementStack.top - 1; i >= this.fragmentContextStackSize_; --i) {
            Info info = this.fElementStack.data[i];
            if (info.element.code == element.code) {
                n = this.fElementStack.top - i;
                break;
            }
            if (!bl && element.nestable && info.element.isBlock()) break;
        }
        return n;
    }

    protected int getParentDepth(HTMLElements.Element[] elementArray, short s) {
        if (elementArray != null) {
            for (int i = this.fElementStack.top - 1; i >= 0; --i) {
                Info info = this.fElementStack.data[i];
                if (info.element.code == s) break;
                for (int j = 0; j < elementArray.length; ++j) {
                    if (info.element.code != elementArray[j].code) continue;
                    return this.fElementStack.top - i;
                }
            }
        }
        return -1;
    }

    protected final XMLAttributes emptyAttributes() {
        this.fEmptyAttrs.removeAllAttributes();
        return this.fEmptyAttrs;
    }

    protected final Augmentations synthesizedAugs() {
        HTMLAugmentations hTMLAugmentations = null;
        if (this.fAugmentations) {
            hTMLAugmentations = this.fInfosetAugs;
            hTMLAugmentations.removeAllItems();
            hTMLAugmentations.putItem(AUGMENTATIONS, (Object)SYNTHESIZED_ITEM);
        }
        return hTMLAugmentations;
    }

    protected static final String modifyName(String string, short s) {
        switch (s) {
            case 1: {
                return string.toUpperCase();
            }
            case 2: {
                return string.toLowerCase();
            }
        }
        return string;
    }

    protected static final short getNamesValue(String string) {
        if (string.equals("lower")) {
            return 2;
        }
        if (string.equals("upper")) {
            return 1;
        }
        return 0;
    }

    void setTagBalancingListener(HTMLTagBalancingListener hTMLTagBalancingListener) {
        this.tagBalancingListener = hTMLTagBalancingListener;
    }

    private void notifyDiscardedStartElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) {
        if (this.tagBalancingListener != null) {
            this.tagBalancingListener.ignoredStartElement(qName, xMLAttributes, augmentations);
        }
    }

    private void notifyDiscardedEndElement(QName qName, Augmentations augmentations) {
        if (this.tagBalancingListener != null) {
            this.tagBalancingListener.ignoredEndElement(qName, augmentations);
        }
    }

    static class ElementEntry {
        private final QName name_;
        private final Augmentations augs_;

        ElementEntry(QName qName, Augmentations augmentations) {
            this.name_ = new QName(qName);
            this.augs_ = augmentations == null ? null : new HTMLAugmentations(augmentations);
        }
    }

    public static class InfoStack {
        public int top;
        public Info[] data = new Info[10];

        public void push(Info info) {
            if (this.top == this.data.length) {
                Info[] infoArray = new Info[this.top + 10];
                System.arraycopy(this.data, 0, infoArray, 0, this.top);
                this.data = infoArray;
            }
            this.data[this.top++] = info;
        }

        public Info peek() {
            return this.data[this.top - 1];
        }

        public Info pop() {
            return this.data[--this.top];
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("InfoStack(");
            for (int i = this.top - 1; i >= 0; --i) {
                stringBuffer.append(this.data[i]);
                if (i == 0) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
    }

    public static class Info {
        public HTMLElements.Element element;
        public QName qname;
        public XMLAttributes attributes;

        public Info(HTMLElements.Element element, QName qName) {
            this(element, qName, null);
        }

        public Info(HTMLElements.Element element, QName qName, XMLAttributes xMLAttributes) {
            int n;
            this.element = element;
            this.qname = new QName(qName);
            if (xMLAttributes != null && (n = xMLAttributes.getLength()) > 0) {
                QName qName2 = new QName();
                XMLAttributesImpl xMLAttributesImpl = new XMLAttributesImpl();
                for (int i = 0; i < n; ++i) {
                    xMLAttributes.getName(i, qName2);
                    String string = xMLAttributes.getType(i);
                    String string2 = xMLAttributes.getValue(i);
                    String string3 = xMLAttributes.getNonNormalizedValue(i);
                    boolean bl = xMLAttributes.isSpecified(i);
                    xMLAttributesImpl.addAttribute(qName2, string, string2);
                    xMLAttributesImpl.setNonNormalizedValue(i, string3);
                    xMLAttributesImpl.setSpecified(i, bl);
                }
                this.attributes = xMLAttributesImpl;
            }
        }

        public String toString() {
            return super.toString() + this.qname;
        }
    }
}

