/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.sax;

import de.l3s.boilerpipe.labels.LabelAction;
import de.l3s.boilerpipe.sax.BoilerpipeHTMLContentHandler;
import de.l3s.boilerpipe.sax.TagAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class MarkupTagAction
implements TagAction {
    private final boolean isBlockLevel;
    private LinkedList<List<String>> labelStack = new LinkedList();
    private static final Pattern PAT_NUM = Pattern.compile("[0-9]+");

    public MarkupTagAction(boolean bl) {
        this.isBlockLevel = bl;
    }

    @Override
    public boolean start(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2, Attributes attributes) throws SAXException {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(5);
        arrayList.add("<" + string);
        String string3 = attributes.getValue("class");
        if (string3 != null && string3.length() > 0) {
            string3 = PAT_NUM.matcher(string3).replaceAll("#");
            string3 = string3.trim();
            stringArray = string3.split("[ ]+");
            arrayList.add("<." + string3.replace(' ', '.'));
            if (stringArray.length > 1) {
                for (String string4 : stringArray) {
                    arrayList.add("<." + string4);
                }
            }
        }
        if ((stringArray = attributes.getValue("id")) != null && stringArray.length() > 0) {
            stringArray = PAT_NUM.matcher((CharSequence)stringArray).replaceAll("#");
            arrayList.add("<#" + (String)stringArray);
        }
        String[] stringArray2 = this.getAncestorLabels();
        ArrayList<String> arrayList2 = new ArrayList<String>((stringArray2.size() + 1) * arrayList.size());
        for (String string4 : arrayList) {
            for (String string5 : stringArray2) {
                arrayList2.add(string5);
                arrayList2.add(string5 + " " + string4);
            }
            arrayList2.add(string4);
        }
        boilerpipeHTMLContentHandler.addLabelAction(new LabelAction(arrayList2.toArray(new String[arrayList2.size()])));
        this.labelStack.add(arrayList);
        return this.isBlockLevel;
    }

    @Override
    public boolean end(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2) throws SAXException {
        this.labelStack.removeLast();
        return this.isBlockLevel;
    }

    @Override
    public boolean changesTagLevel() {
        return this.isBlockLevel;
    }

    private Set<String> getAncestorLabels() {
        HashSet<String> hashSet = new HashSet<String>();
        for (List list : this.labelStack) {
            if (list == null) continue;
            hashSet.addAll(list);
        }
        return hashSet;
    }
}

