/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.sax;

import de.l3s.boilerpipe.BoilerpipeExtractor;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.Image;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.sax.BoilerpipeSAXInput;
import de.l3s.boilerpipe.sax.HTMLDocument;
import de.l3s.boilerpipe.sax.HTMLFetcher;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class ImageExtractor {
    public static final ImageExtractor INSTANCE = new ImageExtractor();
    private static final TagAction TA_IGNORABLE_ELEMENT = new TagAction(){

        @Override
        void beforeStart(Implementation implementation, String string) {
            implementation.inIgnorableElement++;
        }

        @Override
        void afterEnd(Implementation implementation, String string) {
            implementation.inIgnorableElement--;
        }
    };
    private static Map<String, TagAction> TAG_ACTIONS = new HashMap<String, TagAction>();

    public static ImageExtractor getInstance() {
        return INSTANCE;
    }

    private ImageExtractor() {
    }

    public List<Image> process(TextDocument textDocument, String string) throws BoilerpipeProcessingException {
        return this.process(textDocument, new InputSource(new StringReader(string)));
    }

    public List<Image> process(TextDocument textDocument, InputSource inputSource) throws BoilerpipeProcessingException {
        Implementation implementation = new Implementation();
        implementation.process(textDocument, inputSource);
        return implementation.linksHighlight;
    }

    public List<Image> process(URL uRL, BoilerpipeExtractor boilerpipeExtractor) throws IOException, BoilerpipeProcessingException, SAXException {
        HTMLDocument hTMLDocument = HTMLFetcher.fetch(uRL);
        TextDocument textDocument = new BoilerpipeSAXInput(hTMLDocument.toInputSource()).getTextDocument();
        boilerpipeExtractor.process(textDocument);
        InputSource inputSource = hTMLDocument.toInputSource();
        return this.process(textDocument, inputSource);
    }

    static {
        TAG_ACTIONS.put("STYLE", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("SCRIPT", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("OPTION", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("NOSCRIPT", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("EMBED", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("APPLET", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("LINK", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("HEAD", TA_IGNORABLE_ELEMENT);
    }

    private static abstract class TagAction {
        private TagAction() {
        }

        void beforeStart(Implementation implementation, String string) {
        }

        void afterStart(Implementation implementation, String string) {
        }

        void beforeEnd(Implementation implementation, String string) {
        }

        void afterEnd(Implementation implementation, String string) {
        }
    }

    private final class Implementation
    extends AbstractSAXParser
    implements ContentHandler {
        List<Image> linksHighlight;
        private List<Image> linksBuffer;
        private int inIgnorableElement;
        private int characterElementIdx;
        private final BitSet contentBitSet;
        private boolean inHighlight;

        Implementation() {
            super((XMLParserConfiguration)new HTMLConfiguration());
            this.linksHighlight = new ArrayList<Image>();
            this.linksBuffer = new ArrayList<Image>();
            this.inIgnorableElement = 0;
            this.characterElementIdx = 0;
            this.contentBitSet = new BitSet();
            this.inHighlight = false;
            this.setContentHandler(this);
        }

        void process(TextDocument textDocument, InputSource inputSource) throws BoilerpipeProcessingException {
            for (TextBlock textBlock : textDocument.getTextBlocks()) {
                BitSet bitSet;
                if (!textBlock.isContent() || (bitSet = textBlock.getContainedTextElements()) == null) continue;
                this.contentBitSet.or(bitSet);
            }
            try {
                this.parse(inputSource);
            }
            catch (SAXException sAXException) {
                throw new BoilerpipeProcessingException(sAXException);
            }
            catch (IOException iOException) {
                throw new BoilerpipeProcessingException(iOException);
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String string) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            TagAction tagAction = (TagAction)TAG_ACTIONS.get(string2);
            if (tagAction != null) {
                tagAction.beforeStart(this, string2);
            }
            try {
                String string4;
                if (this.inIgnorableElement == 0 && this.inHighlight && "IMG".equalsIgnoreCase(string2) && (string4 = attributes.getValue("src")) != null && string4.length() > 0) {
                    this.linksBuffer.add(new Image(string4, attributes.getValue("width"), attributes.getValue("height"), attributes.getValue("alt")));
                }
            }
            finally {
                if (tagAction != null) {
                    tagAction.afterStart(this, string2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            TagAction tagAction = (TagAction)TAG_ACTIONS.get(string2);
            if (tagAction != null) {
                tagAction.beforeEnd(this, string2);
            }
            try {
                if (this.inIgnorableElement == 0) {
                    // empty if block
                }
            }
            finally {
                if (tagAction != null) {
                    tagAction.afterEnd(this, string2);
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            ++this.characterElementIdx;
            if (this.inIgnorableElement == 0) {
                boolean bl = this.contentBitSet.get(this.characterElementIdx);
                if (!bl) {
                    if (n2 == 0) {
                        return;
                    }
                    boolean bl2 = true;
                    for (int i = n; i < n + n2; ++i) {
                        if (Character.isWhitespace(cArray[i])) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2) {
                        return;
                    }
                }
                this.inHighlight = bl;
                if (this.inHighlight) {
                    this.linksHighlight.addAll(this.linksBuffer);
                    this.linksBuffer.clear();
                }
            }
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
        }
    }
}

