/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.sax;

import de.l3s.boilerpipe.BoilerpipeExtractor;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.sax.BoilerpipeSAXInput;
import de.l3s.boilerpipe.sax.HTMLDocument;
import de.l3s.boilerpipe.sax.HTMLFetcher;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xerces.parsers.AbstractSAXParser;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.cyberneko.html.HTMLConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class HTMLHighlighter {
    private Map<String, Set<String>> tagWhitelist = null;
    private static final Pattern PAT_TAG_NO_TEXT = Pattern.compile("<[^/][^>]*></[^>]*>");
    private static final Pattern PAT_SUPER_TAG = Pattern.compile("^<[^>]*>(<.*?>)</[^>]*>$");
    private boolean outputHighlightOnly = false;
    private String extraStyleSheet = "\n<style type=\"text/css\">\n.x-boilerpipe-mark1 { text-decoration:none; background-color: #ffff42 !important; color: black !important; display:inline !important; visibility:visible !important; }\n</style>\n";
    private String preHighlight = "<span class=\"x-boilerpipe-mark1\">";
    private String postHighlight = "</span>";
    private static final TagAction TA_IGNORABLE_ELEMENT = new TagAction(){

        @Override
        void beforeStart(Implementation implementation, String string) {
            implementation.inIgnorableElement++;
        }

        @Override
        void afterEnd(Implementation implementation, String string) {
            implementation.inIgnorableElement--;
        }
    };
    private static final TagAction TA_HEAD = new TagAction(){

        @Override
        void beforeStart(Implementation implementation, String string) {
            implementation.inIgnorableElement++;
        }

        @Override
        void beforeEnd(Implementation implementation, String string) {
            implementation.html.append(implementation.hl.extraStyleSheet);
        }

        @Override
        void afterEnd(Implementation implementation, String string) {
            implementation.inIgnorableElement--;
        }
    };
    private static Map<String, TagAction> TAG_ACTIONS = new HashMap<String, TagAction>();

    public static HTMLHighlighter newHighlightingInstance() {
        return new HTMLHighlighter(false);
    }

    public static HTMLHighlighter newExtractingInstance() {
        return new HTMLHighlighter(true);
    }

    private HTMLHighlighter(boolean bl) {
        if (bl) {
            this.setOutputHighlightOnly(true);
            this.setExtraStyleSheet("\n<style type=\"text/css\">\nA:before { content:' '; } \nA:after { content:' '; } \nSPAN:before { content:' '; } \nSPAN:after { content:' '; } \n</style>\n");
            this.setPreHighlight("");
            this.setPostHighlight("");
        }
    }

    public String process(TextDocument textDocument, String string) throws BoilerpipeProcessingException {
        return this.process(textDocument, new InputSource(new StringReader(string)));
    }

    public String process(TextDocument textDocument, InputSource inputSource) throws BoilerpipeProcessingException {
        Implementation implementation = new Implementation();
        implementation.process(textDocument, inputSource);
        String string = implementation.html.toString();
        if (this.outputHighlightOnly) {
            boolean bl = true;
            while (bl) {
                bl = false;
                Matcher matcher = PAT_TAG_NO_TEXT.matcher(string);
                if (matcher.find()) {
                    bl = true;
                    string = matcher.replaceAll("");
                }
                if (!(matcher = PAT_SUPER_TAG.matcher(string)).find()) continue;
                bl = true;
                string = matcher.replaceAll(matcher.group(1));
            }
        }
        return string;
    }

    public String process(URL uRL, BoilerpipeExtractor boilerpipeExtractor) throws IOException, BoilerpipeProcessingException, SAXException {
        HTMLDocument hTMLDocument = HTMLFetcher.fetch(uRL);
        TextDocument textDocument = new BoilerpipeSAXInput(hTMLDocument.toInputSource()).getTextDocument();
        boilerpipeExtractor.process(textDocument);
        InputSource inputSource = hTMLDocument.toInputSource();
        return this.process(textDocument, inputSource);
    }

    public boolean isOutputHighlightOnly() {
        return this.outputHighlightOnly;
    }

    public void setOutputHighlightOnly(boolean bl) {
        this.outputHighlightOnly = bl;
    }

    public String getExtraStyleSheet() {
        return this.extraStyleSheet;
    }

    public void setExtraStyleSheet(String string) {
        this.extraStyleSheet = string;
    }

    public String getPreHighlight() {
        return this.preHighlight;
    }

    public void setPreHighlight(String string) {
        this.preHighlight = string;
    }

    public String getPostHighlight() {
        return this.postHighlight;
    }

    public void setPostHighlight(String string) {
        this.postHighlight = string;
    }

    private static String xmlEncode(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public Map<String, Set<String>> getTagWhitelist() {
        return this.tagWhitelist;
    }

    public void setTagWhitelist(Map<String, Set<String>> map) {
        this.tagWhitelist = map;
    }

    static {
        TAG_ACTIONS.put("STYLE", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("SCRIPT", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("OPTION", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("NOSCRIPT", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("OBJECT", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("EMBED", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("APPLET", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("LINK", TA_IGNORABLE_ELEMENT);
        TAG_ACTIONS.put("HEAD", TA_HEAD);
    }

    private final class Implementation
    extends AbstractSAXParser
    implements ContentHandler {
        StringBuilder html;
        private int inIgnorableElement;
        private int characterElementIdx;
        private final BitSet contentBitSet;
        private final HTMLHighlighter hl;

        Implementation() {
            super((XMLParserConfiguration)new HTMLConfiguration());
            this.html = new StringBuilder();
            this.inIgnorableElement = 0;
            this.characterElementIdx = 0;
            this.contentBitSet = new BitSet();
            this.hl = HTMLHighlighter.this;
            this.setContentHandler(this);
        }

        void process(TextDocument textDocument, InputSource inputSource) throws BoilerpipeProcessingException {
            for (TextBlock textBlock : textDocument.getTextBlocks()) {
                BitSet bitSet;
                if (!textBlock.isContent() || (bitSet = textBlock.getContainedTextElements()) == null) continue;
                this.contentBitSet.or(bitSet);
            }
            try {
                this.parse(inputSource);
            }
            catch (SAXException sAXException) {
                throw new BoilerpipeProcessingException(sAXException);
            }
            catch (IOException iOException) {
                throw new BoilerpipeProcessingException(iOException);
            }
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endPrefixMapping(String string) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        @Override
        public void processingInstruction(String string, String string2) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String string) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            Object object;
            TagAction tagAction = (TagAction)TAG_ACTIONS.get(string2);
            if (tagAction != null) {
                tagAction.beforeStart(this, string2);
            }
            boolean bl = false;
            if ("SPAN".equalsIgnoreCase(string2) && "x-boilerpipe-mark1".equals(object = attributes.getValue("class"))) {
                bl = true;
            }
            try {
                if (this.inIgnorableElement == 0) {
                    if (HTMLHighlighter.this.outputHighlightOnly) {
                        // empty if block
                    }
                    if (HTMLHighlighter.this.tagWhitelist == null) {
                        object = null;
                    } else {
                        object = (Set)HTMLHighlighter.this.tagWhitelist.get(string3);
                        if (object == null) {
                            return;
                        }
                    }
                    this.html.append('<');
                    this.html.append(string3);
                    if (!bl) {
                        int n = attributes.getLength();
                        for (int i = 0; i < n; ++i) {
                            String string4 = attributes.getQName(i);
                            if (object != null && !object.contains(string4)) continue;
                            String string5 = attributes.getValue(i);
                            this.html.append(' ');
                            this.html.append(string4);
                            this.html.append("=\"");
                            this.html.append(HTMLHighlighter.xmlEncode(string5));
                            this.html.append("\"");
                        }
                    }
                    this.html.append('>');
                }
            }
            finally {
                if (tagAction != null) {
                    tagAction.afterStart(this, string2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            TagAction tagAction = (TagAction)TAG_ACTIONS.get(string2);
            if (tagAction != null) {
                tagAction.beforeEnd(this, string2);
            }
            try {
                if (this.inIgnorableElement == 0) {
                    if (HTMLHighlighter.this.outputHighlightOnly) {
                        // empty if block
                    }
                    if (HTMLHighlighter.this.tagWhitelist != null && !HTMLHighlighter.this.tagWhitelist.containsKey(string3)) {
                        return;
                    }
                    this.html.append("</");
                    this.html.append(string3);
                    this.html.append('>');
                }
            }
            finally {
                if (tagAction != null) {
                    tagAction.afterEnd(this, string2);
                }
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            ++this.characterElementIdx;
            if (this.inIgnorableElement == 0) {
                boolean bl = this.contentBitSet.get(this.characterElementIdx);
                if (!bl && HTMLHighlighter.this.outputHighlightOnly) {
                    return;
                }
                if (bl) {
                    this.html.append(HTMLHighlighter.this.preHighlight);
                }
                this.html.append(HTMLHighlighter.xmlEncode(String.valueOf(cArray, n, n2)));
                if (bl) {
                    this.html.append(HTMLHighlighter.this.postHighlight);
                }
            }
        }

        @Override
        public void startPrefixMapping(String string, String string2) throws SAXException {
        }
    }

    private static abstract class TagAction {
        private TagAction() {
        }

        void beforeStart(Implementation implementation, String string) {
        }

        void afterStart(Implementation implementation, String string) {
        }

        void beforeEnd(Implementation implementation, String string) {
        }

        void afterEnd(Implementation implementation, String string) {
        }
    }
}

