/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.sax;

import de.l3s.boilerpipe.labels.LabelAction;
import de.l3s.boilerpipe.sax.BoilerpipeHTMLContentHandler;
import de.l3s.boilerpipe.sax.TagAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class CommonTagActions {
    public static final TagAction TA_IGNORABLE_ELEMENT = new TagAction(){

        @Override
        public boolean start(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2, Attributes attributes) {
            ++boilerpipeHTMLContentHandler.inIgnorableElement;
            return true;
        }

        @Override
        public boolean end(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2) {
            --boilerpipeHTMLContentHandler.inIgnorableElement;
            return true;
        }

        @Override
        public boolean changesTagLevel() {
            return true;
        }
    };
    public static final TagAction TA_ANCHOR_TEXT = new TagAction(){

        @Override
        public boolean start(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2, Attributes attributes) throws SAXException {
            if (boilerpipeHTMLContentHandler.inAnchor++ > 0) {
                System.err.println("Warning: SAX input contains nested A elements -- You have probably hit a bug in your HTML parser (e.g., NekoHTML bug #2909310). Please clean the HTML externally and feed it to boilerpipe again. Trying to recover somehow...");
                this.end(boilerpipeHTMLContentHandler, string, string2);
            }
            if (boilerpipeHTMLContentHandler.inIgnorableElement == 0) {
                boilerpipeHTMLContentHandler.addWhitespaceIfNecessary();
                boilerpipeHTMLContentHandler.tokenBuffer.append("$\ue00a<");
                boilerpipeHTMLContentHandler.tokenBuffer.append(' ');
                boilerpipeHTMLContentHandler.sbLastWasWhitespace = true;
            }
            return false;
        }

        @Override
        public boolean end(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2) {
            if (--boilerpipeHTMLContentHandler.inAnchor == 0 && boilerpipeHTMLContentHandler.inIgnorableElement == 0) {
                boilerpipeHTMLContentHandler.addWhitespaceIfNecessary();
                boilerpipeHTMLContentHandler.tokenBuffer.append(">\ue00a$");
                boilerpipeHTMLContentHandler.tokenBuffer.append(' ');
                boilerpipeHTMLContentHandler.sbLastWasWhitespace = true;
            }
            return false;
        }

        @Override
        public boolean changesTagLevel() {
            return true;
        }
    };
    public static final TagAction TA_BODY = new TagAction(){

        @Override
        public boolean start(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2, Attributes attributes) {
            boilerpipeHTMLContentHandler.flushBlock();
            ++boilerpipeHTMLContentHandler.inBody;
            return false;
        }

        @Override
        public boolean end(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2) {
            boilerpipeHTMLContentHandler.flushBlock();
            --boilerpipeHTMLContentHandler.inBody;
            return false;
        }

        @Override
        public boolean changesTagLevel() {
            return true;
        }
    };
    public static final TagAction TA_INLINE_WHITESPACE;
    @Deprecated
    public static final TagAction TA_INLINE;
    public static final TagAction TA_INLINE_NO_WHITESPACE;
    private static final Pattern PAT_FONT_SIZE;
    public static final TagAction TA_BLOCK_LEVEL;
    public static final TagAction TA_FONT;

    private CommonTagActions() {
    }

    static {
        TA_INLINE = TA_INLINE_WHITESPACE = new TagAction(){

            @Override
            public boolean start(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2, Attributes attributes) {
                boilerpipeHTMLContentHandler.addWhitespaceIfNecessary();
                return false;
            }

            @Override
            public boolean end(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2) {
                boilerpipeHTMLContentHandler.addWhitespaceIfNecessary();
                return false;
            }

            @Override
            public boolean changesTagLevel() {
                return false;
            }
        };
        TA_INLINE_NO_WHITESPACE = new TagAction(){

            @Override
            public boolean start(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2, Attributes attributes) {
                return false;
            }

            @Override
            public boolean end(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2) {
                return false;
            }

            @Override
            public boolean changesTagLevel() {
                return false;
            }
        };
        PAT_FONT_SIZE = Pattern.compile("([\\+\\-]?)([0-9])");
        TA_BLOCK_LEVEL = new TagAction(){

            @Override
            public boolean start(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2, Attributes attributes) {
                return true;
            }

            @Override
            public boolean end(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2) {
                return true;
            }

            @Override
            public boolean changesTagLevel() {
                return true;
            }
        };
        TA_FONT = new TagAction(){

            @Override
            public boolean start(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2, Attributes attributes) {
                String string3 = attributes.getValue("size");
                if (string3 != null) {
                    Matcher matcher = PAT_FONT_SIZE.matcher(string3);
                    if (matcher.matches()) {
                        int n;
                        String string4 = matcher.group(1);
                        int n2 = Integer.parseInt(matcher.group(2));
                        if (string4.length() == 0) {
                            n = n2;
                        } else {
                            int n3;
                            if (boilerpipeHTMLContentHandler.fontSizeStack.isEmpty()) {
                                n3 = 3;
                            } else {
                                n3 = 3;
                                for (Integer n4 : boilerpipeHTMLContentHandler.fontSizeStack) {
                                    if (n4 == null) continue;
                                    n3 = n4;
                                    break;
                                }
                            }
                            n = string4.charAt(0) == '+' ? n3 + n2 : n3 - n2;
                        }
                        boilerpipeHTMLContentHandler.fontSizeStack.add(0, n);
                    } else {
                        boilerpipeHTMLContentHandler.fontSizeStack.add(0, null);
                    }
                } else {
                    boilerpipeHTMLContentHandler.fontSizeStack.add(0, null);
                }
                return false;
            }

            @Override
            public boolean end(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2) {
                boilerpipeHTMLContentHandler.fontSizeStack.removeFirst();
                return false;
            }

            @Override
            public boolean changesTagLevel() {
                return false;
            }
        };
    }

    public static final class BlockTagLabelAction
    implements TagAction {
        private final LabelAction action;

        public BlockTagLabelAction(LabelAction labelAction) {
            this.action = labelAction;
        }

        @Override
        public boolean start(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2, Attributes attributes) {
            boilerpipeHTMLContentHandler.addLabelAction(this.action);
            return true;
        }

        @Override
        public boolean end(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2) {
            return true;
        }

        @Override
        public boolean changesTagLevel() {
            return true;
        }
    }

    public static final class InlineTagLabelAction
    implements TagAction {
        private final LabelAction action;

        public InlineTagLabelAction(LabelAction labelAction) {
            this.action = labelAction;
        }

        @Override
        public boolean start(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2, Attributes attributes) {
            boilerpipeHTMLContentHandler.addWhitespaceIfNecessary();
            boilerpipeHTMLContentHandler.addLabelAction(this.action);
            return false;
        }

        @Override
        public boolean end(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2) {
            boilerpipeHTMLContentHandler.addWhitespaceIfNecessary();
            return false;
        }

        @Override
        public boolean changesTagLevel() {
            return false;
        }
    }

    public static final class Chained
    implements TagAction {
        private final TagAction t1;
        private final TagAction t2;

        public Chained(TagAction tagAction, TagAction tagAction2) {
            this.t1 = tagAction;
            this.t2 = tagAction2;
        }

        @Override
        public boolean start(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2, Attributes attributes) throws SAXException {
            return this.t1.start(boilerpipeHTMLContentHandler, string, string2, attributes) | this.t2.start(boilerpipeHTMLContentHandler, string, string2, attributes);
        }

        @Override
        public boolean end(BoilerpipeHTMLContentHandler boilerpipeHTMLContentHandler, String string, String string2) throws SAXException {
            return this.t1.end(boilerpipeHTMLContentHandler, string, string2) | this.t2.end(boilerpipeHTMLContentHandler, string, string2);
        }

        @Override
        public boolean changesTagLevel() {
            return this.t1.changesTagLevel() || this.t2.changesTagLevel();
        }
    }
}

