/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.simple;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.conditions.TextBlockCondition;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.List;
import java.util.ListIterator;

public class SurroundingToContentFilter
implements BoilerpipeFilter {
    public static final SurroundingToContentFilter INSTANCE_TEXT = new SurroundingToContentFilter(new TextBlockCondition(){

        @Override
        public boolean meetsCondition(TextBlock textBlock) {
            return textBlock.getLinkDensity() == 0.0f && textBlock.getNumWords() > 6;
        }
    });
    private final TextBlockCondition cond;

    public SurroundingToContentFilter(TextBlockCondition textBlockCondition) {
        this.cond = textBlockCondition;
    }

    @Override
    public boolean process(TextDocument textDocument) throws BoilerpipeProcessingException {
        List<TextBlock> list = textDocument.getTextBlocks();
        if (list.size() < 3) {
            return false;
        }
        TextBlock textBlock = list.get(0);
        TextBlock textBlock2 = list.get(1);
        boolean bl = false;
        ListIterator<TextBlock> listIterator = list.listIterator(2);
        while (listIterator.hasNext()) {
            TextBlock textBlock3 = (TextBlock)listIterator.next();
            if (!textBlock2.isContent() && textBlock.isContent() && textBlock3.isContent() && this.cond.meetsCondition(textBlock2)) {
                textBlock2.setIsContent(true);
                bl = true;
            }
            textBlock = textBlock3;
            if (!listIterator.hasNext()) break;
            textBlock2 = (TextBlock)listIterator.next();
        }
        return bl;
    }
}

