/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;

public final class LargeBlockSameTagLevelToContentFilter
implements BoilerpipeFilter {
    public static final LargeBlockSameTagLevelToContentFilter INSTANCE = new LargeBlockSameTagLevelToContentFilter();

    private LargeBlockSameTagLevelToContentFilter() {
    }

    @Override
    public boolean process(TextDocument textDocument) throws BoilerpipeProcessingException {
        boolean bl = false;
        int n = -1;
        for (TextBlock textBlock : textDocument.getTextBlocks()) {
            if (!textBlock.isContent() || !textBlock.hasLabel("de.l3s.boilerpipe/VERY_LIKELY_CONTENT")) continue;
            n = textBlock.getTagLevel();
            break;
        }
        if (n == -1) {
            return false;
        }
        for (TextBlock textBlock : textDocument.getTextBlocks()) {
            if (textBlock.isContent() || textBlock.getNumWords() < 100 || textBlock.getTagLevel() != n) continue;
            textBlock.setIsContent(true);
            bl = true;
        }
        return bl;
    }
}

