/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public final class LabelFusion
implements BoilerpipeFilter {
    public static final LabelFusion INSTANCE = new LabelFusion();

    private LabelFusion() {
    }

    @Override
    public boolean process(TextDocument textDocument) throws BoilerpipeProcessingException {
        List<TextBlock> list = textDocument.getTextBlocks();
        if (list.size() < 2) {
            return false;
        }
        boolean bl = false;
        TextBlock textBlock = list.get(0);
        int n = 1;
        ListIterator<TextBlock> listIterator = list.listIterator(n);
        while (listIterator.hasNext()) {
            TextBlock textBlock2 = (TextBlock)listIterator.next();
            if (this.equalLabels(textBlock.getLabels(), textBlock2.getLabels())) {
                textBlock.mergeNext(textBlock2);
                listIterator.remove();
                bl = true;
                continue;
            }
            textBlock = textBlock2;
        }
        return bl;
    }

    private boolean equalLabels(Set<String> set, Set<String> set2) {
        if (set == null || set2 == null) {
            return false;
        }
        return ((Object)this.markupLabelsOnly(set)).equals(this.markupLabelsOnly(set2));
    }

    private Set<String> markupLabelsOnly(Set<String> set) {
        HashSet<String> hashSet = new HashSet<String>(set);
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string.startsWith("<")) continue;
            iterator.remove();
        }
        return hashSet;
    }
}

