/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.Iterator;
import java.util.List;

public final class KeepLargestBlockFilter
implements BoilerpipeFilter {
    public static final KeepLargestBlockFilter INSTANCE = new KeepLargestBlockFilter(false, 0);
    public static final KeepLargestBlockFilter INSTANCE_EXPAND_TO_SAME_TAGLEVEL = new KeepLargestBlockFilter(true, 0);
    public static final KeepLargestBlockFilter INSTANCE_EXPAND_TO_SAME_TAGLEVEL_MIN_WORDS = new KeepLargestBlockFilter(true, 150);
    private final boolean expandToSameLevelText;
    private final int minWords;

    public KeepLargestBlockFilter(boolean bl, int n) {
        this.expandToSameLevelText = bl;
        this.minWords = n;
    }

    @Override
    public boolean process(TextDocument textDocument) throws BoilerpipeProcessingException {
        int n;
        List<TextBlock> list = textDocument.getTextBlocks();
        if (list.size() < 2) {
            return false;
        }
        int n2 = -1;
        TextBlock textBlock = null;
        int n3 = -1;
        int n4 = 0;
        int n5 = -1;
        for (TextBlock textBlock2 : list) {
            if (textBlock2.isContent() && (n = textBlock2.getNumWords()) > n2) {
                textBlock = textBlock2;
                n2 = n;
                n5 = n4;
                if (this.expandToSameLevelText) {
                    n3 = textBlock2.getTagLevel();
                }
            }
            ++n4;
        }
        for (TextBlock textBlock2 : list) {
            if (textBlock2 == textBlock) {
                textBlock2.setIsContent(true);
                textBlock2.addLabel("de.l3s.boilerpipe/VERY_LIKELY_CONTENT");
                continue;
            }
            textBlock2.setIsContent(false);
            textBlock2.addLabel("de.l3s.boilerpipe/MIGHT_BE_CONTENT");
        }
        if (this.expandToSameLevelText && n5 != -1) {
            TextBlock textBlock2;
            Iterator<TextBlock> iterator = list.listIterator(n5);
            while (iterator.hasPrevious() && (n = (textBlock2 = (TextBlock)iterator.previous()).getTagLevel()) >= n3) {
                if (n != n3 || textBlock2.getNumWords() < this.minWords) continue;
                textBlock2.setIsContent(true);
            }
            iterator = list.listIterator(n5);
            while (iterator.hasNext() && (n = (textBlock2 = (TextBlock)iterator.next()).getTagLevel()) >= n3) {
                if (n != n3 || textBlock2.getNumWords() < this.minWords) continue;
                textBlock2.setIsContent(true);
            }
        }
        return true;
    }
}

