/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class DocumentTitleMatchClassifier
implements BoilerpipeFilter {
    private final Set<String> potentialTitles;
    private static final Pattern PAT_REMOVE_CHARACTERS = Pattern.compile("[\\?\\!\\.\\-\\:]+");

    public DocumentTitleMatchClassifier(String string) {
        if (string == null) {
            this.potentialTitles = null;
        } else {
            string = string.replace('\u00a0', ' ');
            string = string.replace("'", "");
            if ((string = string.trim().toLowerCase()).length() == 0) {
                this.potentialTitles = null;
            } else {
                this.potentialTitles = new HashSet<String>();
                this.potentialTitles.add(string);
                String string2 = this.getLongestPart(string, "[ ]*[\\|\u00bb|-][ ]*");
                if (string2 != null) {
                    this.potentialTitles.add(string2);
                }
                if ((string2 = this.getLongestPart(string, "[ ]*[\\|\u00bb|:][ ]*")) != null) {
                    this.potentialTitles.add(string2);
                }
                if ((string2 = this.getLongestPart(string, "[ ]*[\\|\u00bb|:\\(\\)][ ]*")) != null) {
                    this.potentialTitles.add(string2);
                }
                if ((string2 = this.getLongestPart(string, "[ ]*[\\|\u00bb|:\\(\\)\\-][ ]*")) != null) {
                    this.potentialTitles.add(string2);
                }
                if ((string2 = this.getLongestPart(string, "[ ]*[\\|\u00bb|,|:\\(\\)\\-][ ]*")) != null) {
                    this.potentialTitles.add(string2);
                }
                if ((string2 = this.getLongestPart(string, "[ ]*[\\|\u00bb|,|:\\(\\)\\-\u00a0][ ]*")) != null) {
                    this.potentialTitles.add(string2);
                }
                this.addPotentialTitles(this.potentialTitles, string, "[ ]+[\\|][ ]+", 4);
                this.addPotentialTitles(this.potentialTitles, string, "[ ]+[\\-][ ]+", 4);
                this.potentialTitles.add(string.replaceFirst(" - [^\\-]+$", ""));
                this.potentialTitles.add(string.replaceFirst("^[^\\-]+ - ", ""));
            }
        }
    }

    public Set<String> getPotentialTitles() {
        return this.potentialTitles;
    }

    private void addPotentialTitles(Set<String> set, String string, String string2, int n) {
        String[] stringArray = string.split(string2);
        if (stringArray.length == 1) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            String string3 = stringArray[i];
            if (string3.contains(".com") || (n2 = string3.split("[\b ]+").length) < n) continue;
            set.add(string3);
        }
    }

    private String getLongestPart(String string, String string2) {
        String[] stringArray = string.split(string2);
        if (stringArray.length == 1) {
            return null;
        }
        int n = 0;
        String string3 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            String string4 = stringArray[i];
            if (string4.contains(".com") || (n2 = string4.split("[\b ]+").length) <= n && string4.length() <= string3.length()) continue;
            n = n2;
            string3 = string4;
        }
        if (string3.length() == 0) {
            return null;
        }
        return string3.trim();
    }

    @Override
    public boolean process(TextDocument textDocument) throws BoilerpipeProcessingException {
        if (this.potentialTitles == null) {
            return false;
        }
        boolean bl = false;
        for (TextBlock textBlock : textDocument.getTextBlocks()) {
            String string = textBlock.getText();
            string = string.replace('\u00a0', ' ');
            string = string.replace("'", "");
            if (this.potentialTitles.contains(string = string.trim().toLowerCase())) {
                textBlock.addLabel("de.l3s.boilerpipe/TITLE");
                bl = true;
                break;
            }
            if (!this.potentialTitles.contains(string = PAT_REMOVE_CHARACTERS.matcher(string).replaceAll("").trim())) continue;
            textBlock.addLabel("de.l3s.boilerpipe/TITLE");
            bl = true;
            break;
        }
        return bl;
    }
}

