/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.Iterator;
import java.util.List;

public final class BlockProximityFusion
implements BoilerpipeFilter {
    private final int maxBlocksDistance;
    public static final BlockProximityFusion MAX_DISTANCE_1 = new BlockProximityFusion(1, false, false);
    public static final BlockProximityFusion MAX_DISTANCE_1_SAME_TAGLEVEL = new BlockProximityFusion(1, false, true);
    public static final BlockProximityFusion MAX_DISTANCE_1_CONTENT_ONLY = new BlockProximityFusion(1, true, false);
    public static final BlockProximityFusion MAX_DISTANCE_1_CONTENT_ONLY_SAME_TAGLEVEL = new BlockProximityFusion(1, true, true);
    private final boolean contentOnly;
    private final boolean sameTagLevelOnly;

    public BlockProximityFusion(int n, boolean bl, boolean bl2) {
        this.maxBlocksDistance = n;
        this.contentOnly = bl;
        this.sameTagLevelOnly = bl2;
    }

    @Override
    public boolean process(TextDocument textDocument) throws BoilerpipeProcessingException {
        int n;
        TextBlock textBlock;
        List<TextBlock> list = textDocument.getTextBlocks();
        if (list.size() < 2) {
            return false;
        }
        boolean bl = false;
        if (this.contentOnly) {
            textBlock = null;
            n = 0;
            for (TextBlock textBlock2 : list) {
                ++n;
                if (!textBlock2.isContent()) continue;
                textBlock = textBlock2;
                break;
            }
            if (textBlock == null) {
                return false;
            }
        } else {
            textBlock = list.get(0);
            n = 1;
        }
        Iterator<TextBlock> iterator = list.listIterator(n);
        while (iterator.hasNext()) {
            TextBlock textBlock2;
            textBlock2 = iterator.next();
            if (!textBlock2.isContent()) {
                textBlock = textBlock2;
                continue;
            }
            int n2 = textBlock2.getOffsetBlocksStart() - textBlock.getOffsetBlocksEnd() - 1;
            if (n2 <= this.maxBlocksDistance) {
                boolean bl2 = true;
                if (!(!this.contentOnly || textBlock.isContent() && textBlock2.isContent())) {
                    bl2 = false;
                }
                if (bl2 && this.sameTagLevelOnly && textBlock.getTagLevel() != textBlock2.getTagLevel()) {
                    bl2 = false;
                }
                if (bl2) {
                    textBlock.mergeNext(textBlock2);
                    iterator.remove();
                    bl = true;
                    continue;
                }
                textBlock = textBlock2;
                continue;
            }
            textBlock = textBlock2;
        }
        return bl;
    }
}

