/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.heuristics;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public final class AddPrecedingLabelsFilter
implements BoilerpipeFilter {
    public static final AddPrecedingLabelsFilter INSTANCE = new AddPrecedingLabelsFilter("");
    public static final AddPrecedingLabelsFilter INSTANCE_PRE = new AddPrecedingLabelsFilter("^");
    private final String labelPrefix;

    public AddPrecedingLabelsFilter(String string) {
        this.labelPrefix = string;
    }

    @Override
    public boolean process(TextDocument textDocument) throws BoilerpipeProcessingException {
        List<TextBlock> list = textDocument.getTextBlocks();
        if (list.size() < 2) {
            return false;
        }
        boolean bl = false;
        int n = list.size();
        TextBlock textBlock = null;
        ListIterator<TextBlock> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious() && --n > 0) {
            if (textBlock == null) {
                textBlock = listIterator.previous();
                continue;
            }
            TextBlock textBlock2 = listIterator.previous();
            Set<String> set = textBlock2.getLabels();
            if (set != null && !set.isEmpty()) {
                for (String string : set) {
                    textBlock.addLabel(this.labelPrefix + string);
                }
                bl = true;
            }
            textBlock = textBlock2;
        }
        return bl;
    }
}

