/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.english;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;

public class TerminatingBlocksFinder
implements BoilerpipeFilter {
    public static final TerminatingBlocksFinder INSTANCE = new TerminatingBlocksFinder();

    public static TerminatingBlocksFinder getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument textDocument) throws BoilerpipeProcessingException {
        boolean bl = false;
        for (TextBlock textBlock : textDocument.getTextBlocks()) {
            int n = textBlock.getNumWords();
            if (n >= 15) continue;
            String string = textBlock.getText().trim();
            int n2 = string.length();
            if (n2 >= 8) {
                String string2 = string.toLowerCase();
                if (!string2.startsWith("comments") && !TerminatingBlocksFinder.startsWithNumber(string2, n2, " comments", " users responded in") && !string2.startsWith("\u00a9 reuters") && !string2.startsWith("please rate this") && !string2.startsWith("post a comment") && !string2.contains("what you think...") && !string2.contains("add your comment") && !string2.contains("add comment") && !string2.contains("reader views") && !string2.contains("have your say") && !string2.contains("reader comments") && !string2.contains("r\u00e4tta artikeln") && !string2.equals("thanks for your comments - this feedback is now closed")) continue;
                textBlock.addLabel("de.l3s.boilerpipe/INDICATES_END_OF_TEXT");
                bl = true;
                continue;
            }
            if ((double)textBlock.getLinkDensity() != 1.0 || !string.equals("Comment")) continue;
            textBlock.addLabel("de.l3s.boilerpipe/INDICATES_END_OF_TEXT");
        }
        return bl;
    }

    private static boolean startsWithNumber(String string, int n, String ... stringArray) {
        int n2;
        for (n2 = 0; n2 < n && TerminatingBlocksFinder.isDigit(string.charAt(n2)); ++n2) {
        }
        if (n2 != 0) {
            for (String string2 : stringArray) {
                if (!string.startsWith(string2, n2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }
}

