/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.english;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.filters.english.HeuristicFilterBase;

public final class MinFulltextWordsFilter
extends HeuristicFilterBase
implements BoilerpipeFilter {
    public static final MinFulltextWordsFilter DEFAULT_INSTANCE = new MinFulltextWordsFilter(30);
    private final int minWords;

    public static MinFulltextWordsFilter getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public MinFulltextWordsFilter(int n) {
        this.minWords = n;
    }

    @Override
    public boolean process(TextDocument textDocument) throws BoilerpipeProcessingException {
        boolean bl = false;
        for (TextBlock textBlock : textDocument.getTextBlocks()) {
            if (!textBlock.isContent() || MinFulltextWordsFilter.getNumFullTextWords(textBlock) >= this.minWords) continue;
            textBlock.setIsContent(false);
            bl = true;
        }
        return bl;
    }
}

