/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.english;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.filters.english.HeuristicFilterBase;
import java.util.List;

public final class KeepLargestFulltextBlockFilter
extends HeuristicFilterBase
implements BoilerpipeFilter {
    public static final KeepLargestFulltextBlockFilter INSTANCE = new KeepLargestFulltextBlockFilter();

    @Override
    public boolean process(TextDocument textDocument) throws BoilerpipeProcessingException {
        List<TextBlock> list = textDocument.getTextBlocks();
        if (list.size() < 2) {
            return false;
        }
        int n = -1;
        TextBlock textBlock = null;
        for (TextBlock textBlock2 : list) {
            int n2;
            if (!textBlock2.isContent() || (n2 = KeepLargestFulltextBlockFilter.getNumFullTextWords(textBlock2)) <= n) continue;
            textBlock = textBlock2;
            n = n2;
        }
        if (textBlock == null) {
            return false;
        }
        for (TextBlock textBlock2 : list) {
            if (textBlock2 == textBlock) {
                textBlock2.setIsContent(true);
                continue;
            }
            textBlock2.setIsContent(false);
            textBlock2.addLabel("de.l3s.boilerpipe/MIGHT_BE_CONTENT");
        }
        return true;
    }
}

