/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.english;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.filters.english.HeuristicFilterBase;
import java.util.List;
import java.util.ListIterator;

public final class IgnoreBlocksAfterContentFromEndFilter
extends HeuristicFilterBase
implements BoilerpipeFilter {
    public static final IgnoreBlocksAfterContentFromEndFilter INSTANCE = new IgnoreBlocksAfterContentFromEndFilter();

    private IgnoreBlocksAfterContentFromEndFilter() {
    }

    @Override
    public boolean process(TextDocument textDocument) throws BoilerpipeProcessingException {
        boolean bl = false;
        int n = 0;
        List<TextBlock> list = textDocument.getTextBlocks();
        if (!list.isEmpty()) {
            ListIterator<TextBlock> listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                TextBlock textBlock = listIterator.previous();
                if (textBlock.hasLabel("de.l3s.boilerpipe/INDICATES_END_OF_TEXT")) {
                    textBlock.addLabel("de.l3s.boilerpipe/STRICTLY_NOT_CONTENT");
                    textBlock.removeLabel("de.l3s.boilerpipe/MIGHT_BE_CONTENT");
                    textBlock.setIsContent(false);
                    bl = true;
                    continue;
                }
                if (!textBlock.isContent() || (n += textBlock.getNumWords()) <= 200) continue;
                break;
            }
        }
        return bl;
    }
}

