/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.filters.english;

import de.l3s.boilerpipe.BoilerpipeFilter;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextBlock;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.filters.english.HeuristicFilterBase;

public final class IgnoreBlocksAfterContentFilter
extends HeuristicFilterBase
implements BoilerpipeFilter {
    public static final IgnoreBlocksAfterContentFilter DEFAULT_INSTANCE = new IgnoreBlocksAfterContentFilter(60);
    public static final IgnoreBlocksAfterContentFilter INSTANCE_200 = new IgnoreBlocksAfterContentFilter(200);
    private final int minNumWords;

    public static IgnoreBlocksAfterContentFilter getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public IgnoreBlocksAfterContentFilter(int n) {
        this.minNumWords = n;
    }

    @Override
    public boolean process(TextDocument textDocument) throws BoilerpipeProcessingException {
        boolean bl = false;
        int n = 0;
        boolean bl2 = false;
        for (TextBlock textBlock : textDocument.getTextBlocks()) {
            boolean bl3 = textBlock.hasLabel("de.l3s.boilerpipe/INDICATES_END_OF_TEXT");
            if (textBlock.isContent()) {
                n += IgnoreBlocksAfterContentFilter.getNumFullTextWords(textBlock);
            }
            if (bl3 && n >= this.minNumWords) {
                bl2 = true;
            }
            if (!bl2) continue;
            bl = true;
            textBlock.setIsContent(false);
        }
        return bl;
    }
}

