/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.extractors;

import de.l3s.boilerpipe.BoilerpipeExtractor;
import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.sax.BoilerpipeSAXInput;
import de.l3s.boilerpipe.sax.HTMLFetcher;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ExtractorBase
implements BoilerpipeExtractor {
    @Override
    public String getText(String string) throws BoilerpipeProcessingException {
        try {
            return this.getText(new BoilerpipeSAXInput(new InputSource(new StringReader(string))).getTextDocument());
        }
        catch (SAXException sAXException) {
            throw new BoilerpipeProcessingException(sAXException);
        }
    }

    @Override
    public String getText(InputSource inputSource) throws BoilerpipeProcessingException {
        try {
            return this.getText(new BoilerpipeSAXInput(inputSource).getTextDocument());
        }
        catch (SAXException sAXException) {
            throw new BoilerpipeProcessingException(sAXException);
        }
    }

    public String getText(URL uRL) throws BoilerpipeProcessingException {
        try {
            return this.getText(HTMLFetcher.fetch(uRL).toInputSource());
        }
        catch (IOException iOException) {
            throw new BoilerpipeProcessingException(iOException);
        }
    }

    @Override
    public String getText(Reader reader) throws BoilerpipeProcessingException {
        return this.getText(new InputSource(reader));
    }

    @Override
    public String getText(TextDocument textDocument) throws BoilerpipeProcessingException {
        this.process(textDocument);
        return textDocument.getContent();
    }
}

