/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.extractors;

import de.l3s.boilerpipe.BoilerpipeProcessingException;
import de.l3s.boilerpipe.document.TextDocument;
import de.l3s.boilerpipe.extractors.ExtractorBase;
import de.l3s.boilerpipe.filters.english.IgnoreBlocksAfterContentFilter;
import de.l3s.boilerpipe.filters.english.NumWordsRulesClassifier;
import de.l3s.boilerpipe.filters.english.TerminatingBlocksFinder;
import de.l3s.boilerpipe.filters.heuristics.BlockProximityFusion;
import de.l3s.boilerpipe.filters.heuristics.DocumentTitleMatchClassifier;
import de.l3s.boilerpipe.filters.heuristics.ExpandTitleToContentFilter;
import de.l3s.boilerpipe.filters.heuristics.KeepLargestBlockFilter;
import de.l3s.boilerpipe.filters.heuristics.LargeBlockSameTagLevelToContentFilter;
import de.l3s.boilerpipe.filters.heuristics.ListAtEndFilter;
import de.l3s.boilerpipe.filters.heuristics.TrailingHeadlineToBoilerplateFilter;
import de.l3s.boilerpipe.filters.simple.BoilerplateBlockFilter;

public final class ArticleExtractor
extends ExtractorBase {
    public static final ArticleExtractor INSTANCE = new ArticleExtractor();

    public static ArticleExtractor getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean process(TextDocument textDocument) throws BoilerpipeProcessingException {
        return TerminatingBlocksFinder.INSTANCE.process(textDocument) | new DocumentTitleMatchClassifier(textDocument.getTitle()).process(textDocument) | NumWordsRulesClassifier.INSTANCE.process(textDocument) | IgnoreBlocksAfterContentFilter.DEFAULT_INSTANCE.process(textDocument) | TrailingHeadlineToBoilerplateFilter.INSTANCE.process(textDocument) | BlockProximityFusion.MAX_DISTANCE_1.process(textDocument) | BoilerplateBlockFilter.INSTANCE_KEEP_TITLE.process(textDocument) | BlockProximityFusion.MAX_DISTANCE_1_CONTENT_ONLY_SAME_TAGLEVEL.process(textDocument) | KeepLargestBlockFilter.INSTANCE_EXPAND_TO_SAME_TAGLEVEL_MIN_WORDS.process(textDocument) | ExpandTitleToContentFilter.INSTANCE.process(textDocument) | LargeBlockSameTagLevelToContentFilter.INSTANCE.process(textDocument) | ListAtEndFilter.INSTANCE.process(textDocument);
    }
}

