/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.document;

import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;

public class TextBlock
implements Cloneable {
    boolean isContent = false;
    private CharSequence text;
    Set<String> labels = null;
    int offsetBlocksStart;
    int offsetBlocksEnd;
    int numWords;
    int numWordsInAnchorText;
    int numWordsInWrappedLines;
    int numWrappedLines;
    float textDensity;
    float linkDensity;
    BitSet containedTextElements;
    private int numFullTextWords = 0;
    private int tagLevel;
    private static final BitSet EMPTY_BITSET = new BitSet();
    public static final TextBlock EMPTY_START = new TextBlock("", EMPTY_BITSET, 0, 0, 0, 0, -1);
    public static final TextBlock EMPTY_END = new TextBlock("", EMPTY_BITSET, 0, 0, 0, 0, Integer.MAX_VALUE);

    public TextBlock(String string) {
        this(string, null, 0, 0, 0, 0, 0);
    }

    public TextBlock(String string, BitSet bitSet, int n, int n2, int n3, int n4, int n5) {
        this.text = string;
        this.containedTextElements = bitSet;
        this.numWords = n;
        this.numWordsInAnchorText = n2;
        this.numWordsInWrappedLines = n3;
        this.numWrappedLines = n4;
        this.offsetBlocksStart = n5;
        this.offsetBlocksEnd = n5;
        this.initDensities();
    }

    public boolean isContent() {
        return this.isContent;
    }

    public boolean setIsContent(boolean bl) {
        if (bl != this.isContent) {
            this.isContent = bl;
            return true;
        }
        return false;
    }

    public String getText() {
        return ((Object)this.text).toString();
    }

    public int getNumWords() {
        return this.numWords;
    }

    public int getNumWordsInAnchorText() {
        return this.numWordsInAnchorText;
    }

    public float getTextDensity() {
        return this.textDensity;
    }

    public float getLinkDensity() {
        return this.linkDensity;
    }

    public void mergeNext(TextBlock textBlock) {
        if (!(this.text instanceof StringBuilder)) {
            this.text = new StringBuilder(this.text);
        }
        StringBuilder stringBuilder = (StringBuilder)this.text;
        stringBuilder.append('\n');
        stringBuilder.append(textBlock.text);
        this.numWords += textBlock.numWords;
        this.numWordsInAnchorText += textBlock.numWordsInAnchorText;
        this.numWordsInWrappedLines += textBlock.numWordsInWrappedLines;
        this.numWrappedLines += textBlock.numWrappedLines;
        this.offsetBlocksStart = Math.min(this.offsetBlocksStart, textBlock.offsetBlocksStart);
        this.offsetBlocksEnd = Math.max(this.offsetBlocksEnd, textBlock.offsetBlocksEnd);
        this.initDensities();
        this.isContent |= textBlock.isContent;
        if (this.containedTextElements == null) {
            this.containedTextElements = (BitSet)textBlock.containedTextElements.clone();
        } else {
            this.containedTextElements.or(textBlock.containedTextElements);
        }
        this.numFullTextWords += textBlock.numFullTextWords;
        if (textBlock.labels != null) {
            if (this.labels == null) {
                this.labels = new HashSet<String>(textBlock.labels);
            } else {
                this.labels.addAll(textBlock.labels);
            }
        }
        this.tagLevel = Math.min(this.tagLevel, textBlock.tagLevel);
    }

    private void initDensities() {
        if (this.numWordsInWrappedLines == 0) {
            this.numWordsInWrappedLines = this.numWords;
            this.numWrappedLines = 1;
        }
        this.textDensity = (float)this.numWordsInWrappedLines / (float)this.numWrappedLines;
        this.linkDensity = this.numWords == 0 ? 0.0f : (float)this.numWordsInAnchorText / (float)this.numWords;
    }

    public int getOffsetBlocksStart() {
        return this.offsetBlocksStart;
    }

    public int getOffsetBlocksEnd() {
        return this.offsetBlocksEnd;
    }

    public String toString() {
        return "[" + this.offsetBlocksStart + "-" + this.offsetBlocksEnd + ";tl=" + this.tagLevel + "; nw=" + this.numWords + ";nwl=" + this.numWrappedLines + ";ld=" + this.linkDensity + "]\t" + (this.isContent ? "CONTENT" : "boilerplate") + "," + this.labels + "\n" + this.getText();
    }

    public void addLabel(String string) {
        if (this.labels == null) {
            this.labels = new HashSet<String>(2);
        }
        this.labels.add(string);
    }

    public boolean hasLabel(String string) {
        return this.labels != null && this.labels.contains(string);
    }

    public boolean removeLabel(String string) {
        return this.labels != null && this.labels.remove(string);
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public void addLabels(Set<String> set) {
        if (set == null) {
            return;
        }
        if (this.labels == null) {
            this.labels = new HashSet<String>(set);
        } else {
            this.labels.addAll(set);
        }
    }

    public void addLabels(String ... stringArray) {
        if (stringArray == null) {
            return;
        }
        if (this.labels == null) {
            this.labels = new HashSet<String>();
        }
        for (String string : stringArray) {
            this.labels.add(string);
        }
    }

    public BitSet getContainedTextElements() {
        return this.containedTextElements;
    }

    protected TextBlock clone() {
        TextBlock textBlock;
        try {
            textBlock = (TextBlock)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        if (this.text != null && !(this.text instanceof String)) {
            textBlock.text = new StringBuilder(this.text);
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            textBlock.labels = new HashSet<String>(this.labels);
        }
        if (this.containedTextElements != null) {
            textBlock.containedTextElements = (BitSet)this.containedTextElements.clone();
        }
        return textBlock;
    }

    public int getTagLevel() {
        return this.tagLevel;
    }

    public void setTagLevel(int n) {
        this.tagLevel = n;
    }
}

