/*
 * Decompiled with CFR 0.152.
 */
package de.l3s.boilerpipe.document;

import de.l3s.boilerpipe.document.Media;

public class Image
extends Media
implements Comparable<Image> {
    private final String src;
    private final String width;
    private final String height;
    private final String alt;
    private final int area;

    public Image(String string, String string2, String string3, String string4) {
        this.src = string;
        if (string == null) {
            throw new NullPointerException("src attribute must not be null");
        }
        this.width = Image.nullTrim(string2);
        this.height = Image.nullTrim(string3);
        this.alt = Image.nullTrim(string4);
        if (string2 != null && string3 != null) {
            int n;
            try {
                n = Integer.parseInt(string2) * Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                n = -1;
            }
            this.area = n;
        } else {
            this.area = -1;
        }
    }

    public String getSrc() {
        return this.src;
    }

    public String getWidth() {
        return this.width;
    }

    public String getHeight() {
        return this.height;
    }

    public String getAlt() {
        return this.alt;
    }

    private static String nullTrim(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        return string;
    }

    public int getArea() {
        return this.area;
    }

    public String toString() {
        return this.src + "\twidth=" + this.width + "\theight=" + this.height + "\talt=" + this.alt + "\tarea=" + this.area;
    }

    @Override
    public int compareTo(Image image) {
        if (image == this) {
            return 0;
        }
        if (this.area > image.area) {
            return -1;
        }
        if (this.area == image.area) {
            return this.src.compareTo(image.src);
        }
        return 1;
    }
}

