(ns datomock.impl
  (:require [datomic.api :as d])
  (:import (datomic Log Database)
           (java.util UUID)))

(defn ^Database make-empty-db []
  (let [uri (str "datomic:mem://" "datomock-" (UUID/randomUUID))
        db (do (d/create-database uri)
               (d/db (d/connect uri)))]
    (d/delete-database uri)
    db))

(defrecord MockConnState [db logVec])

(defn log-item
  [tx-res]
  {:t (d/basis-t (:db-after tx-res))
   :data (:tx-data tx-res)})

(defn log-tail [logVec startT endT]
  (filter (fn [{:as log-item, :keys [t]}]
            (and
              (or (nil? startT) (<= startT t))
              (or (nil? endT) (< t endT))
              )) logVec))

(defrecord ForkedLog [rootLog forkT logVec]
  Log
  (txRange [_ startT endT]
    (concat
      (when rootLog
        (seq (d/tx-range rootLog startT (if (nil? endT) forkT (min forkT endT)))))
      (log-tail logVec startT endT)
      )))
