/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.impl;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import voldemort.utils.ClusterStarter;
import voldemort.utils.RemoteOperationException;
import voldemort.utils.impl.CommandLineParameterizer;
import voldemort.utils.impl.CommandLineRemoteOperation;
import voldemort.utils.impl.CommandOutputListener;
import voldemort.utils.impl.LoggingCommandOutputListener;
import voldemort.utils.impl.UnixCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshClusterStarter
extends CommandLineRemoteOperation
implements ClusterStarter {
    private final AtomicInteger completedCounter = new AtomicInteger();
    private final CommandOutputListener outputListener = new SshClusterStarterCommandOutputListener();
    private final Collection<String> hostNames;
    private final File sshPrivateKey;
    private final String hostUserId;
    private final String voldemortRootDirectory;
    private final String voldemortHomeDirectory;
    private final Map<String, Integer> nodeIds;

    public SshClusterStarter(Collection<String> hostNames, File sshPrivateKey, String hostUserId, String voldemortRootDirectory, String voldemortHomeDirectory, Map<String, Integer> nodeIds) {
        this.hostNames = hostNames;
        this.sshPrivateKey = sshPrivateKey;
        this.hostUserId = hostUserId;
        this.voldemortRootDirectory = voldemortRootDirectory;
        this.voldemortHomeDirectory = voldemortHomeDirectory;
        this.nodeIds = nodeIds;
    }

    @Override
    public void execute() throws RemoteOperationException {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)"Starting Voldemort cluster");
        }
        CommandLineParameterizer commandLineParameterizer = new CommandLineParameterizer("SshClusterStarter.ssh" + (this.sshPrivateKey != null ? "" : ".nokey"));
        HashMap<String, String> hostNameCommandLineMap = new HashMap<String, String>();
        for (String hostName : this.hostNames) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("hostName", hostName);
            parameters.put("hostUserId", this.hostUserId);
            parameters.put("sshPrivateKey", this.sshPrivateKey != null ? this.sshPrivateKey.getAbsolutePath() : null);
            parameters.put("voldemortRootDirectory", this.voldemortRootDirectory);
            parameters.put("voldemortHomeDirectory", this.voldemortHomeDirectory);
            parameters.put("voldemortNodeId", this.nodeIds.get(hostName).toString());
            hostNameCommandLineMap.put(hostName, commandLineParameterizer.parameterize(parameters));
        }
        this.execute(hostNameCommandLineMap);
    }

    protected Callable<Object> getCallable(UnixCommand command) {
        LoggingCommandOutputListener commandOutputListener = new LoggingCommandOutputListener(this.outputListener, this.logger, true);
        return new ClusterStarterCallable<Object>(command, commandOutputListener);
    }

    private boolean hasStartupCompleted() {
        return this.hostNames.size() == this.completedCounter.get();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClusterStarterCallable<T>
    implements Callable<T> {
        private final UnixCommand command;
        private final CommandOutputListener commandOutputListener;

        public ClusterStarterCallable(UnixCommand command, CommandOutputListener commandOutputListener) {
            this.command = command;
            this.commandOutputListener = commandOutputListener;
        }

        @Override
        public T call() throws Exception {
            int exitCode = this.command.execute(this.commandOutputListener);
            if (exitCode != 143 && exitCode != 255 || !SshClusterStarter.this.hasStartupCompleted()) {
                throw new Exception("Process on " + this.command.getHostName() + " exited with code " + exitCode + ". Please check the logs for details.");
            }
            return null;
        }
    }

    public class SshClusterStarterCommandOutputListener
    implements CommandOutputListener {
        public void outputReceived(String hostName, String line) {
            if (line.contains("Startup completed")) {
                SshClusterStarter.this.completedCounter.incrementAndGet();
                if (SshClusterStarter.this.logger.isInfoEnabled()) {
                    SshClusterStarter.this.logger.info((Object)(hostName + " startup complete"));
                    if (SshClusterStarter.this.hasStartupCompleted()) {
                        SshClusterStarter.this.logger.info((Object)"Cluster startup complete");
                    }
                }
            }
        }
    }
}

