/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.impl;

import org.apache.commons.logging.Log;
import voldemort.utils.impl.CommandOutputListener;
import voldemort.utils.impl.DelegatingCommandOutputListener;

public class LoggingCommandOutputListener
extends DelegatingCommandOutputListener {
    private final Log logger;
    private final boolean shouldProcessExceptions;

    public LoggingCommandOutputListener(CommandOutputListener delegate, Log logger, boolean shouldProcessExceptions) {
        super(delegate);
        this.logger = logger;
        this.shouldProcessExceptions = shouldProcessExceptions;
    }

    public void outputReceived(String hostName, String line) {
        if (this.shouldProcessExceptions && (line.contains("Exception") || line.startsWith("\tat"))) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)(hostName + ": " + line));
            }
        } else if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(hostName + ": " + line));
        }
        super.outputReceived(hostName, line);
    }
}

