/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import voldemort.utils.RemoteOperationException;
import voldemort.utils.impl.CommandLineParser;
import voldemort.utils.impl.ExitCodeCallable;
import voldemort.utils.impl.LoggingCommandOutputListener;
import voldemort.utils.impl.UnixCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CommandLineRemoteOperation {
    protected final Log logger = LogFactory.getLog(this.getClass());

    CommandLineRemoteOperation() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(Map<String, String> hostNameCommandLineMap) throws RemoteOperationException {
        CommandLineParser commandLineParser = new CommandLineParser();
        ExecutorService threadPool = Executors.newFixedThreadPool(hostNameCommandLineMap.size());
        ArrayList futures = new ArrayList();
        for (Map.Entry<String, String> entry : hostNameCommandLineMap.entrySet()) {
            String string = entry.getKey();
            String commandLine = entry.getValue();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Command to execute: " + commandLine));
            }
            List<String> commandArgs = commandLineParser.parse(commandLine);
            UnixCommand command = new UnixCommand(string, commandArgs);
            Callable<?> callable = this.getCallable(command);
            Future<?> future = threadPool.submit(callable);
            futures.add(future);
        }
        try {
            StringBuilder errors = new StringBuilder();
            for (Future future : futures) {
                Throwable t = null;
                try {
                    future.get();
                }
                catch (ExecutionException ex) {
                    t = ex.getCause();
                }
                catch (Exception e) {
                    t = e;
                }
                if (t == null) continue;
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn((Object)t, t);
                }
                if (errors.length() > 0) {
                    errors.append("; ");
                }
                errors.append(t.getMessage());
            }
            if (errors.length() > 0) {
                throw new RemoteOperationException(errors.toString());
            }
        }
        finally {
            block17: {
                threadPool.shutdown();
                try {
                    threadPool.awaitTermination(60L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    if (!this.logger.isWarnEnabled()) break block17;
                    this.logger.warn((Object)e, (Throwable)e);
                }
            }
        }
    }

    protected Callable<?> getCallable(UnixCommand command) {
        LoggingCommandOutputListener commandOutputListener = new LoggingCommandOutputListener(null, this.logger, true);
        return new ExitCodeCallable(command, commandOutputListener);
    }
}

