/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.app;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import joptsimple.OptionSet;
import org.apache.commons.io.FileUtils;
import voldemort.utils.HostNamePair;
import voldemort.utils.app.VoldemortApp;
import voldemort.utils.impl.TypicaEc2Connection;

public class VoldemortEc2InstanceTerminatorApp
extends VoldemortApp {
    public static void main(String[] args) throws Exception {
        new VoldemortEc2InstanceTerminatorApp().run(args);
    }

    protected String getScriptName() {
        return "voldemort-ec2instanceterminator.sh";
    }

    public void run(String[] args) throws Exception {
        this.parser.accepts("help", "Prints this help");
        this.parser.accepts("logging", "Options are \"debug\", \"info\" (default), \"warn\", \"error\", or \"off\"").withRequiredArg();
        this.parser.accepts("accessid", "Access ID (used instead of accessidfile)").withRequiredArg();
        this.parser.accepts("accessidfile", "Access ID file (used instead of accessid)").withRequiredArg();
        this.parser.accepts("secretkey", "Secret key (used instead of secretkeyfile)").withRequiredArg();
        this.parser.accepts("secretkeyfile", "Secret key file (used instead of secretkey)").withRequiredArg();
        this.parser.accepts("hostnames", "File containing host names").withRequiredArg();
        this.parser.accepts("instances", "File containing instance IDs").withRequiredArg();
        OptionSet options = this.parse(args);
        String accessId = this.getAccessId(options);
        String secretKey = this.getSecretKey(options);
        TypicaEc2Connection ec2Connection = new TypicaEc2Connection(accessId, secretKey);
        ArrayList<String> hostNames = new ArrayList<String>();
        File hostNamesFile = this.getInputFile(options, "hostnames");
        File instancesFile = this.getInputFile(options, "instances");
        if (hostNamesFile == null && instancesFile == null) {
            this.printUsage();
        }
        if (hostNamesFile != null) {
            List<HostNamePair> hostNamePairs = this.getHostNamesPairsFromFile(hostNamesFile);
            for (HostNamePair hostNamePair : hostNamePairs) {
                hostNames.add(hostNamePair.getExternalHostName());
            }
            ec2Connection.deleteInstancesByHostName(hostNames);
        }
        if (instancesFile != null) {
            List instanceIds = FileUtils.readLines((File)instancesFile);
            ec2Connection.deleteInstancesByInstanceId(instanceIds);
        }
    }
}

