/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.app;

import java.util.Arrays;
import java.util.List;
import joptsimple.OptionSet;
import voldemort.utils.CmdUtils;
import voldemort.utils.Ec2Connection;
import voldemort.utils.HostNamePair;
import voldemort.utils.app.VoldemortApp;
import voldemort.utils.impl.TypicaEc2Connection;

public class VoldemortEc2InstanceCreatorApp
extends VoldemortApp {
    public static void main(String[] args) throws Exception {
        new VoldemortEc2InstanceCreatorApp().run(args);
    }

    protected String getScriptName() {
        return "voldemort-ec2instancecreator.sh";
    }

    public void run(String[] args) throws Exception {
        this.parser.accepts("help", "Prints this help");
        this.parser.accepts("logging", "Options are \"debug\", \"info\" (default), \"warn\", \"error\", or \"off\"").withRequiredArg();
        this.parser.accepts("accessid", "Access ID (used instead of accessidfile)").withRequiredArg();
        this.parser.accepts("accessidfile", "Access ID file (used instead of accessid)").withRequiredArg();
        this.parser.accepts("secretkey", "Secret key (used instead of secretkeyfile)").withRequiredArg();
        this.parser.accepts("secretkeyfile", "Secret key file (used instead of secretkey)").withRequiredArg();
        this.parser.accepts("securitygroups", "Security groups to allow on instances (optional)").withRequiredArg();
        this.parser.accepts("ami", "AMI").withRequiredArg();
        this.parser.accepts("keypairid", "KeyPairID").withRequiredArg();
        this.parser.accepts("instances", "Number of instances (default 1)").withRequiredArg().ofType(Integer.class);
        this.parser.accepts("instancetype", "Instance type; options are " + (Object)((Object)Ec2Connection.Ec2InstanceType.DEFAULT) + " (default), " + (Object)((Object)Ec2Connection.Ec2InstanceType.LARGE) + ", " + (Object)((Object)Ec2Connection.Ec2InstanceType.XLARGE) + ", " + (Object)((Object)Ec2Connection.Ec2InstanceType.MEDIUM_HCPU) + ", and " + (Object)((Object)Ec2Connection.Ec2InstanceType.XLARGE_HCPU)).withRequiredArg();
        OptionSet options = this.parse(args);
        String accessId = this.getAccessId(options);
        String secretKey = this.getSecretKey(options);
        String ami = this.getRequiredString(options, "ami");
        String keypairId = this.getRequiredString(options, "keypairid");
        int instanceCount = (Integer)CmdUtils.valueOf((OptionSet)options, (String)"instances", (Object)1);
        String securityGroups = (String)CmdUtils.valueOf((OptionSet)options, (String)"securitygroups", null);
        List<String> securityGroupsList = securityGroups != null ? Arrays.asList(securityGroups.split(",")) : null;
        Ec2Connection.Ec2InstanceType instanceType = null;
        try {
            instanceType = Ec2Connection.Ec2InstanceType.valueOf((String)CmdUtils.valueOf((OptionSet)options, (String)"instancetype", (Object)"DEFAULT"));
        }
        catch (Exception e) {
            this.printUsage();
        }
        TypicaEc2Connection ec2Connection = new TypicaEc2Connection(accessId, secretKey);
        List<HostNamePair> hostNamePairs = ec2Connection.createInstances(ami, keypairId, instanceType, instanceCount, securityGroupsList);
        StringBuilder s = new StringBuilder();
        for (HostNamePair hostNamePair : hostNamePairs) {
            s.append(hostNamePair.getExternalHostName());
            s.append('=');
            s.append(hostNamePair.getInternalHostName());
            s.append(System.getProperty("line.separator"));
        }
        System.out.print(s);
    }
}

