/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.app;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import joptsimple.OptionSet;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import voldemort.utils.CmdUtils;
import voldemort.utils.HostNamePair;
import voldemort.utils.RemoteOperationException;
import voldemort.utils.app.VoldemortApp;
import voldemort.utils.impl.SshClusterStarter;
import voldemort.utils.impl.SshClusterStopper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortClusterStarterApp
extends VoldemortApp {
    public static void main(String[] args) throws Exception {
        new VoldemortClusterStarterApp().run(args);
    }

    @Override
    protected String getScriptName() {
        return "voldemort-clusterstarter.sh";
    }

    @Override
    public void run(String[] args) throws Exception {
        this.parser.accepts("help", "Prints this help");
        this.parser.accepts("logging", "Options are \"debug\", \"info\" (default), \"warn\", \"error\", or \"off\"").withRequiredArg();
        this.parser.accepts("hostnames", "File containing host names").withRequiredArg();
        this.parser.accepts("sshprivatekey", "File containing SSH private key (optional)").withRequiredArg();
        this.parser.accepts("hostuserid", "User ID on remote host").withRequiredArg();
        this.parser.accepts("voldemortroot", "Voldemort's root directory on remote host").withRequiredArg();
        this.parser.accepts("voldemorthome", "Voldemort's home directory on remote host").withRequiredArg();
        this.parser.accepts("clusterxml", "Voldemort's cluster.xml file on the local file system; used to determine host names").withRequiredArg();
        OptionSet options = this.parse(args);
        File hostNamesFile = this.getRequiredInputFile(options, "hostnames");
        List<HostNamePair> hostNamePairs = this.getHostNamesPairsFromFile(hostNamesFile);
        final ArrayList<String> externalHostNames = new ArrayList<String>();
        ArrayList<String> internalHostNames = new ArrayList<String>();
        for (HostNamePair hostNamePair : hostNamePairs) {
            externalHostNames.add(hostNamePair.getExternalHostName());
            internalHostNames.add(hostNamePair.getInternalHostName());
        }
        final File sshPrivateKey = this.getInputFile(options, "sshprivatekey");
        final String hostUserId = (String)CmdUtils.valueOf((OptionSet)options, (String)"hostuserid", (Object)"root");
        String voldemortHomeDirectory = this.getRequiredString(options, "voldemorthome");
        final String voldemortRootDirectory = this.getRequiredString(options, "voldemortroot");
        File clusterXmlFile = this.getRequiredInputFile(options, "clusterxml");
        Map<String, Integer> nodeIds = this.getNodeIds(hostNamesFile, clusterXmlFile, hostNamePairs);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                SshClusterStopper operation = new SshClusterStopper(externalHostNames, sshPrivateKey, hostUserId, voldemortRootDirectory, true);
                try {
                    operation.execute();
                }
                catch (RemoteOperationException e) {
                    e.printStackTrace();
                }
            }
        });
        SshClusterStarter operation = new SshClusterStarter(externalHostNames, sshPrivateKey, hostUserId, voldemortRootDirectory, voldemortHomeDirectory, nodeIds);
        operation.execute();
    }

    private Map<String, Integer> getNodeIds(File hostNamesFile, File clusterXmlFile, List<HostNamePair> hostNamePairs) throws Exception {
        HashMap<String, Integer> nodeIds = new HashMap<String, Integer>();
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = documentBuilder.parse(clusterXmlFile);
        NodeList documentChildren = document.getChildNodes().item(0).getChildNodes();
        for (int i = 0; i < documentChildren.getLength(); ++i) {
            Node documentChild = documentChildren.item(i);
            if (!documentChild.getNodeName().equals("server")) continue;
            NodeList serverChildren = documentChild.getChildNodes();
            String internalHostName = null;
            String id = null;
            for (int j = 0; j < serverChildren.getLength(); ++j) {
                Node serverChild = serverChildren.item(j);
                if (serverChild.getNodeName().equals("host")) {
                    internalHostName = serverChild.getTextContent();
                    continue;
                }
                if (!serverChild.getNodeName().equals("id")) continue;
                id = serverChild.getTextContent();
            }
            if (internalHostName != null && id != null) {
                for (HostNamePair hostNamePair : hostNamePairs) {
                    if (!hostNamePair.getInternalHostName().equals(internalHostName)) continue;
                    nodeIds.put(hostNamePair.getExternalHostName(), Integer.parseInt(id));
                }
                continue;
            }
            throw new Exception(clusterXmlFile.getAbsolutePath() + " appears to be corrupt; could not determine the <host> and/or <id> values for the <server> node");
        }
        if (nodeIds.size() != hostNamePairs.size()) {
            throw new Exception(clusterXmlFile.getAbsolutePath() + " appears to be corrupt; not all of the hosts from " + hostNamesFile.getAbsolutePath() + " were represented in " + clusterXmlFile.getAbsolutePath());
        }
        return nodeIds;
    }
}

