/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils.app;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import joptsimple.OptionSet;
import voldemort.utils.CmdUtils;
import voldemort.utils.HostNamePair;
import voldemort.utils.app.VoldemortApp;
import voldemort.utils.impl.SshRemoteTest;

public class VoldemortClusterRemoteTestApp
extends VoldemortApp {
    public static void main(String[] args) throws Exception {
        new VoldemortClusterRemoteTestApp().run(args);
    }

    protected String getScriptName() {
        return "voldemort-clusterremotetest.sh";
    }

    public void run(String[] args) throws Exception {
        this.parser.accepts("help", "Prints this help");
        this.parser.accepts("logging", "Options are \"debug\", \"info\" (default), \"warn\", \"error\", or \"off\"").withRequiredArg();
        this.parser.accepts("hostnames", "File containing host names").withRequiredArg();
        this.parser.accepts("sshprivatekey", "File containing SSH private key (optional)").withRequiredArg();
        this.parser.accepts("hostuserid", "User ID on remote host").withRequiredArg();
        this.parser.accepts("commands", "File containing per-host commands").withRequiredArg();
        OptionSet options = this.parse(args);
        List<HostNamePair> hostNamePairs = this.getHostNamesPairsFromFile(this.getRequiredInputFile(options, "hostnames"));
        ArrayList<String> hostNames = new ArrayList<String>();
        for (HostNamePair hostNamePair : hostNamePairs) {
            hostNames.add(hostNamePair.getExternalHostName());
        }
        File sshPrivateKey = this.getInputFile(options, "sshprivatekey");
        String hostUserId = (String)CmdUtils.valueOf((OptionSet)options, (String)"hostuserid", (Object)"root");
        Map<String, String> commands = this.getRequiredPropertiesFile(this.getRequiredInputFile(options, "commands"));
        SshRemoteTest operation = new SshRemoteTest(hostNames, sshPrivateKey, hostUserId, commands);
        operation.execute();
    }
}

