/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import voldemort.utils.Ec2RemoteTestConfig;
import voldemort.utils.Ec2RemoteTestUtils;
import voldemort.utils.HostNamePair;
import voldemort.utils.RemoteTestConfig;
import voldemort.utils.RemoteTestUtils;

public class Ec2SmokeTest {
    private static Ec2SmokeTestConfig ec2SmokeTestConfig;
    private static List<HostNamePair> hostNamePairs;
    private static List<String> hostNames;
    private static Map<String, Integer> nodeIds;
    private static final Logger logger;

    @BeforeClass
    public static void setUpClass() throws Exception {
        ec2SmokeTestConfig = new Ec2SmokeTestConfig();
        hostNamePairs = Ec2RemoteTestUtils.createInstances(ec2SmokeTestConfig);
        hostNames = RemoteTestUtils.toHostNames(hostNamePairs);
        nodeIds = RemoteTestUtils.generateClusterDescriptor(hostNamePairs, "test", (RemoteTestConfig)ec2SmokeTestConfig);
        if (logger.isInfoEnabled()) {
            logger.info((Object)"Sleeping for 30 seconds to give EC2 instances some time to complete startup");
        }
        Thread.sleep(30000L);
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (hostNames != null) {
            Ec2RemoteTestUtils.destroyInstances(hostNames, ec2SmokeTestConfig);
        }
    }

    @Before
    public void setUp() throws Exception {
        RemoteTestUtils.deploy(hostNames, ec2SmokeTestConfig);
        RemoteTestUtils.startClusterAsync(hostNames, ec2SmokeTestConfig, nodeIds);
    }

    @After
    public void tearDown() throws Exception {
        RemoteTestUtils.stopClusterQuiet(hostNames, ec2SmokeTestConfig);
    }

    @Test
    public void testRemoteTest() throws Exception {
        HashMap<String, String> commands = new HashMap<String, String>();
        int i = 0;
        int numRequests = ec2SmokeTestConfig.numRequests;
        int iterations = ec2SmokeTestConfig.iterations;
        String storeName = "test";
        String bootstrapUrl = "tcp://" + hostNamePairs.get(0).getInternalHostName() + ":6666";
        for (HostNamePair hostNamePair : hostNamePairs) {
            int startKey = i * numRequests;
            int rampTime = i * ec2SmokeTestConfig.rampTime;
            String sleepCommand = "sleep " + rampTime;
            String cdCommand = "cd " + ec2SmokeTestConfig.getVoldemortRootDirectory();
            String remoteTestCommand = "./bin/voldemort-remote-test.sh -w -d --iterations " + iterations + " --start-key-index " + startKey + " " + bootstrapUrl + " " + storeName + " " + numRequests;
            commands.put(hostNamePair.getExternalHostName(), sleepCommand + " ; " + cdCommand + " ; " + remoteTestCommand);
            ++i;
        }
        RemoteTestUtils.executeRemoteTest(hostNames, ec2SmokeTestConfig, commands);
    }

    @Test
    public void testTemporaryNodeOffline() throws Exception {
        String offlineHostName = hostNames.get(0);
        Integer nodeId = nodeIds.get(offlineHostName);
        RemoteTestUtils.stopClusterNode(offlineHostName, ec2SmokeTestConfig);
        RemoteTestUtils.startClusterNode(offlineHostName, ec2SmokeTestConfig, nodeId);
    }

    static {
        logger = Logger.getLogger(Ec2SmokeTest.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Ec2SmokeTestConfig
    extends Ec2RemoteTestConfig {
        private int rampTime;
        private int iterations;
        private int numRequests;

        private Ec2SmokeTestConfig() {
        }

        @Override
        protected void init(Properties properties) {
            super.init(properties);
            this.rampTime = this.getIntProperty(properties, "ec2RampTime");
            this.iterations = this.getIntProperty(properties, "ec2Iterations");
            this.numRequests = this.getIntProperty(properties, "ec2NumRequests");
        }

        @Override
        protected List<String> getRequiredPropertyNames() {
            List<String> requireds = super.getRequiredPropertyNames();
            requireds.addAll(Arrays.asList("ec2RampTime", "ec2Iterations", "ec2NumRequests"));
            return requireds;
        }
    }
}

