/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import voldemort.VoldemortException;
import voldemort.utils.RemoteTestConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ec2RemoteTestConfig
extends RemoteTestConfig {
    protected String accessId;
    protected String secretKey;
    protected String ami;
    protected String keyPairId;
    protected int instanceCount;
    protected File instanceIdFile;

    public Ec2RemoteTestConfig() {
        Properties properties = this.getEc2Properties();
        this.init(properties);
    }

    public String getAccessId() {
        return this.accessId;
    }

    public void setAccessId(String accessId) {
        this.accessId = accessId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getAmi() {
        return this.ami;
    }

    public void setAmi(String ami) {
        this.ami = ami;
    }

    public String getKeyPairId() {
        return this.keyPairId;
    }

    public void setKeyPairId(String keyPairId) {
        this.keyPairId = keyPairId;
    }

    public int getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(int instanceCount) {
        this.instanceCount = instanceCount;
    }

    public File getInstanceIdFile() {
        return this.instanceIdFile;
    }

    public void setInstanceIdFile(File instanceIdFile) {
        this.instanceIdFile = instanceIdFile;
    }

    protected void init(Properties properties) {
        this.setAccessId(properties.getProperty("ec2AccessId"));
        this.setSecretKey(properties.getProperty("ec2SecretKey"));
        this.setAmi(properties.getProperty("ec2Ami"));
        this.setKeyPairId(properties.getProperty("ec2KeyPairId"));
        this.setHostUserId(properties.getProperty("ec2HostUserId"));
        this.setSshPrivateKey(this.getFileProperty(properties, "ec2SshPrivateKeyPath"));
        this.setVoldemortRootDirectory(properties.getProperty("ec2VoldemortRootDirectory"));
        this.setVoldemortHomeDirectory(properties.getProperty("ec2VoldemortHomeDirectory"));
        this.setSourceDirectory(this.getFileProperty(properties, "ec2SourceDirectory"));
        this.setParentDirectory(properties.getProperty("ec2ParentDirectory"));
        this.setClusterXmlFile(this.getFileProperty(properties, "ec2ClusterXmlFile"));
        this.setInstanceCount(this.getIntProperty(properties, "ec2InstanceCount"));
        this.setInstanceIdFile(this.getFileProperty(properties, "ec2InstanceIdFile"));
    }

    protected File getFileProperty(Properties properties, String propertyName) {
        String value = properties.getProperty(propertyName);
        return value != null ? new File(value) : null;
    }

    protected int getIntProperty(Properties properties, String propertyName) {
        String value = properties.getProperty(propertyName);
        return value != null ? Integer.parseInt(value) : 0;
    }

    protected int getIntProperty(Properties properties, String propertyName, int defaultValue) {
        String value = properties.getProperty(propertyName);
        return value != null ? Integer.parseInt(value) : defaultValue;
    }

    protected Properties getEc2Properties() {
        String propertiesFileName = System.getProperty("ec2PropertiesFile");
        List<String> requireds = this.getRequiredPropertyNames();
        if (propertiesFileName == null) {
            throw new VoldemortException("ec2PropertiesFile system property must be defined that provides the path to file containing the following required properties: " + StringUtils.join(requireds, (String)", "));
        }
        Properties properties = new Properties();
        FileInputStream in = null;
        try {
            in = new FileInputStream(propertiesFileName);
            properties.load(in);
        }
        catch (IOException e) {
            try {
                throw new VoldemortException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        for (String required : requireds) {
            if (System.getProperties().containsKey(required)) {
                properties.put(required, System.getProperty(required));
            }
            if (properties.containsKey(required)) continue;
            throw new VoldemortException("Required properties: " + StringUtils.join(requireds, (String)", ") + "; missing " + required);
        }
        return properties;
    }

    protected List<String> getRequiredPropertyNames() {
        return new ArrayList<String>(Arrays.asList("ec2AccessId", "ec2SecretKey", "ec2Ami", "ec2KeyPairId", "ec2HostUserId", "ec2VoldemortRootDirectory", "ec2VoldemortHomeDirectory", "ec2SourceDirectory", "ec2ParentDirectory", "ec2ClusterXmlFile", "ec2InstanceCount", "ec2InstanceIdFile"));
    }
}

