/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import voldemort.ServerTestUtils;
import voldemort.client.protocol.RequestFormatType;
import voldemort.client.protocol.admin.AdminClient;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.client.rebalance.AbstractRebalanceTest;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.store.InvalidMetadataException;
import voldemort.store.metadata.MetadataStore;
import voldemort.store.socket.SocketDestination;
import voldemort.store.socket.SocketPool;
import voldemort.store.socket.SocketStore;
import voldemort.utils.Ec2RemoteTestConfig;
import voldemort.utils.Ec2RemoteTestUtils;
import voldemort.utils.HostNamePair;
import voldemort.utils.RemoteTestConfig;
import voldemort.utils.RemoteTestUtils;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ec2RebalanceTest
extends AbstractRebalanceTest {
    private static final Logger logger = Logger.getLogger(Ec2RebalanceTest.class);
    private static Ec2RebalanceTestConfig ec2RebalanceTestConfig;
    private static List<HostNamePair> hostNamePairs;
    private static List<String> hostNames;
    private Map<Integer, String> nodeIdsInv = new HashMap<Integer, String>();
    private List<String> activeHostNames = new ArrayList<String>();

    @BeforeClass
    public static void ec2Setup() throws Exception {
        ec2RebalanceTestConfig = new Ec2RebalanceTestConfig();
        NUM_KEYS = ec2RebalanceTestConfig.numKeys;
        hostNamePairs = Ec2RemoteTestUtils.createInstances(ec2RebalanceTestConfig);
        hostNames = RemoteTestUtils.toHostNames(hostNamePairs);
        logger.info((Object)"Sleeping for 30 seconds to let the instances start up.");
        Thread.sleep(30000L);
    }

    @AfterClass
    public static void ec2TearDown() throws Exception {
        if (hostNames != null) {
            Ec2RemoteTestUtils.destroyInstances(hostNames, ec2RebalanceTestConfig);
        }
    }

    @After
    public void ec2Cleanup() throws Exception {
        if (this.activeHostNames.size() > 0) {
            RemoteTestUtils.stopClusterQuiet(this.activeHostNames, ec2RebalanceTestConfig);
            RemoteTestUtils.cleanupCluster(this.activeHostNames, ec2RebalanceTestConfig);
        }
    }

    protected Cluster updateCluster(Cluster template) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Map.Entry<Integer, String> entry : this.nodeIdsInv.entrySet()) {
            int nodeId = entry.getKey();
            String hostName = entry.getValue();
            Node tmplNode = template.getNodeById(nodeId);
            Node node = new Node(nodeId, hostName, tmplNode.getHttpPort(), tmplNode.getSocketPort(), tmplNode.getAdminPort(), tmplNode.getPartitionIds());
            nodes.add(node);
        }
        return new Cluster(template.getName(), nodes);
    }

    protected SocketStore getSocketStore(String storeName, String host, int port, boolean isRouted) {
        SocketPool socketPool = new SocketPool(2, 60000, 60000, 32768);
        return new SocketStore(storeName, new SocketDestination(host, port, RequestFormatType.PROTOCOL_BUFFERS), socketPool, isRouted);
    }

    protected Cluster startServers(Cluster template, String StoreDefXmlFile, List<Integer> nodeToStart, Map<String, String> configProps) throws Exception {
        if (ec2RebalanceTestConfig.getInstanceCount() < template.getNumberOfNodes()) {
            throw new IllegalStateException("instanceCount must be >= number of nodes in the cluster");
        }
        Map<String, Integer> nodeIds = RemoteTestUtils.generateClusterDescriptor(hostNamePairs, template, (RemoteTestConfig)ec2RebalanceTestConfig);
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Map.Entry<String, Integer> entry : nodeIds.entrySet()) {
            String hostName = entry.getKey();
            int nodeId = entry.getValue();
            Node tmplNode = template.getNodeById(nodeId);
            Node node = new Node(nodeId, hostName, tmplNode.getHttpPort(), tmplNode.getSocketPort(), tmplNode.getAdminPort(), tmplNode.getPartitionIds());
            nodes.add(node);
            this.nodeIdsInv.put(nodeId, hostName);
            this.activeHostNames.add(hostName);
        }
        Cluster cluster = new Cluster(template.getName(), nodes);
        RemoteTestUtils.deploy(this.activeHostNames, ec2RebalanceTestConfig);
        RemoteTestUtils.startClusterAsync(this.activeHostNames, ec2RebalanceTestConfig, nodeIds);
        logger.info((Object)"Sleeping for ten seconds to let Voldemort start.");
        Thread.sleep(10000L);
        return cluster;
    }

    protected void stopServer(List<Integer> nodesToStop) throws Exception {
        ArrayList<String> hostsToStop = new ArrayList<String>();
        for (int nodeId : nodesToStop) {
            hostsToStop.add(this.nodeIdsInv.get(nodeId));
        }
        RemoteTestUtils.stopCluster(hostsToStop, ec2RebalanceTestConfig);
    }

    @Test
    public void testGracefulRecovery() throws Exception {
        Cluster currentCluster = ServerTestUtils.getLocalCluster((int)2, (int[][])new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8}, new int[0]});
        Cluster targetCluster = ServerTestUtils.getLocalCluster((int)2, (int[][])new int[][]{{0, 1, 4, 5, 6, 7, 8}, {2, 3}});
        List<Integer> serverList = Arrays.asList(0, 1);
        currentCluster = this.startServers(currentCluster, storeDefFile, serverList, null);
        targetCluster = this.updateCluster(targetCluster);
        this.populateData(currentCluster, Arrays.asList(0));
        AdminClient adminClient = new AdminClient(this.getBootstrapUrl(currentCluster, 0), new AdminClientConfig());
        RebalancePartitionsInfo rebalancePartitionsInfo = new RebalancePartitionsInfo(1, 0, Arrays.asList(2, 3), new ArrayList(0), Arrays.asList(testStoreName), 0);
        int requestId = adminClient.rebalanceNode(rebalancePartitionsInfo);
        logger.info((Object)("started rebalanceNode, request id = " + requestId));
        Thread.sleep(25L);
        this.stopServer(Arrays.asList(1));
        logger.info((Object)"waiting ten seconds after shutting down the node");
        Thread.sleep(10000L);
        String hostName = currentCluster.getNodeById(1).getHost();
        RemoteTestUtils.startClusterNode(hostName, ec2RebalanceTestConfig, 1);
        adminClient.stop();
        adminClient = new AdminClient(this.getBootstrapUrl(currentCluster, 0), new AdminClientConfig());
        Versioned serverState = adminClient.getRemoteServerState(1);
        int delay = 250;
        int maxDelay = 30000;
        int timeout = 300000;
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() < start + (long)timeout && serverState.getValue() != MetadataStore.VoldemortState.NORMAL_SERVER) {
            Thread.sleep(delay);
            if (delay < maxDelay) {
                delay *= 2;
            }
            serverState = adminClient.getRemoteServerState(1);
            logger.info((Object)("serverState -> " + serverState.getValue()));
        }
        if (serverState.getValue() == MetadataStore.VoldemortState.NORMAL_SERVER) {
            for (int nodeId : Arrays.asList(1)) {
                List availablePartitions = targetCluster.getNodeById(nodeId).getPartitionIds();
                List unavailablePartitions = this.getUnavailablePartitions(targetCluster, availablePartitions);
                try {
                    this.checkGetEntries(currentCluster.getNodeById(nodeId), targetCluster, unavailablePartitions, availablePartitions);
                }
                catch (InvalidMetadataException e) {
                    logger.warn((Object)e);
                }
            }
        } else {
            Assert.fail((String)"Server state never reached NORMAL_SERVER");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Ec2RebalanceTestConfig
    extends Ec2RemoteTestConfig {
        private String configDirName;
        private int numKeys;

        private Ec2RebalanceTestConfig() {
        }

        @Override
        protected void init(Properties properties) {
            super.init(properties);
            this.configDirName = properties.getProperty("ec2ConfigDirName");
            this.numKeys = this.getIntProperty(properties, "ec2NumKeys", 1000);
            try {
                FileUtils.copyFile((File)new File(storeDefFile), (File)new File(this.configDirName + "/stores.xml"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        protected List<String> getRequiredPropertyNames() {
            List<String> requireds = super.getRequiredPropertyNames();
            requireds.add("ec2ConfigDirName");
            return requireds;
        }
    }
}

