/*
 * Decompiled with CFR 0.152.
 */
package voldemort.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import voldemort.utils.ClusterGenerator;
import voldemort.utils.ClusterNodeDescriptor;
import voldemort.utils.HostNamePair;
import voldemort.utils.impl.TypicaEc2Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ec2InstanceRemoteTestUtils {
    public static List<HostNamePair> createInstances(String ec2AccessId, String ec2SecretKey, String ec2Ami, String ec2KeyPairId, int count) throws Exception {
        TypicaEc2Connection ec2 = new TypicaEc2Connection(ec2AccessId, ec2SecretKey);
        return null;
    }

    public static void destroyInstances(String ec2AccessId, String ec2SecretKey, List<String> hostNames) throws Exception {
        TypicaEc2Connection ec2 = new TypicaEc2Connection(ec2AccessId, ec2SecretKey);
    }

    public static List<HostNamePair> listInstances(String ec2AccessId, String ec2SecretKey) throws Exception {
        TypicaEc2Connection ec2 = new TypicaEc2Connection(ec2AccessId, ec2SecretKey);
        return ec2.list();
    }

    public static Map<String, Integer> generateClusterDescriptor(List<HostNamePair> hostNamePairs, String clusterName, String path) throws Exception {
        ArrayList<String> hostNames = new ArrayList<String>();
        for (HostNamePair hostNamePair : hostNamePairs) {
            hostNames.add(hostNamePair.getInternalHostName());
        }
        ClusterGenerator clusterGenerator = new ClusterGenerator();
        List<ClusterNodeDescriptor> nodes = clusterGenerator.createClusterNodeDescriptors(hostNames, 3);
        String clusterXml = clusterGenerator.createClusterDescriptor(clusterName, nodes);
        FileUtils.writeStringToFile((File)new File(path), (String)clusterXml);
        HashMap<String, Integer> nodeIds = new HashMap<String, Integer>();
        for (ClusterNodeDescriptor node : nodes) {
            for (HostNamePair hostNamePair : hostNamePairs) {
                if (!node.getHostName().equals(hostNamePair.getInternalHostName())) continue;
                nodeIds.put(hostNamePair.getExternalHostName(), node.getId());
            }
        }
        return nodeIds;
    }
}

