/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.mr;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableCollection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.jdom.JDOMException;
import voldemort.cluster.Cluster;
import voldemort.server.VoldemortConfig;
import voldemort.store.StoreDefinition;
import voldemort.store.readonly.checksum.CheckSum;
import voldemort.store.readonly.mr.HadoopStoreBuilder;
import voldemort.utils.CmdUtils;
import voldemort.utils.ReflectUtils;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HadoopStoreJobRunner
extends Configured
implements Tool {
    private static void printUsage(OptionParser parser, Exception e) throws IOException {
        System.err.println("Usage: $VOLDEMORT_HOME/bin/hadoop-build-readonly-store.sh \\");
        System.err.println("          [genericOptions] [options]\n");
        System.err.println("Options:");
        parser.printHelpOn((OutputStream)System.err);
        System.err.println();
        ToolRunner.printGenericCommandUsage((PrintStream)System.err);
        if (e != null) {
            System.err.println("\nAn exception ocurred:");
            e.printStackTrace(System.err);
        }
    }

    private static OptionParser configureParser() {
        OptionParser parser = new OptionParser();
        parser.accepts("input", "input file(s) for the Map step.").withRequiredArg();
        parser.accepts("tmpdir", "output directory for the Reduce step.").withRequiredArg();
        parser.accepts("output", "final output directory for store.").withRequiredArg();
        parser.accepts("mapper", "store builder mapper class.").withRequiredArg();
        parser.accepts("cluster", "local path to cluster.xml.").withRequiredArg();
        parser.accepts("storedefinitions", "local path to stores.xml.").withRequiredArg();
        parser.accepts("storename", "store name from store definition.").withRequiredArg();
        parser.accepts("replication", "replication factor (default=2).").withRequiredArg();
        parser.accepts("chunksize", "maximum size of a chunk in bytes.").withRequiredArg();
        parser.accepts("inputformat", "JavaClassName (default=text).").withRequiredArg();
        parser.accepts("jar", "mapper class jar if not in $HADOOP_CLASSPATH.").withRequiredArg();
        parser.accepts("checksum", "enable checksum using md5, adler32, crc32").withRequiredArg();
        parser.accepts("force-overwrite", "deletes final output directory if present.");
        parser.accepts("help", "print usage information");
        return parser;
    }

    public int run(String[] args) throws Exception {
        String inputFormatClassName;
        Set missing;
        OptionParser parser = HadoopStoreJobRunner.configureParser();
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            HadoopStoreJobRunner.printUsage(parser, null);
            System.exit(0);
        }
        if ((missing = CmdUtils.missing((OptionSet)options, (String[])new String[]{"input", "output", "mapper", "cluster", "storedefinitions", "storename", "chunksize"})).size() > 0) {
            System.err.println("Missing required arguments: " + Joiner.on((String)", ").join((Iterable)missing) + "\n");
            HadoopStoreJobRunner.printUsage(parser, null);
            System.exit(1);
        }
        File clusterFile = new File((String)options.valueOf("cluster"));
        Cluster cluster = new ClusterMapper().readCluster((Reader)new BufferedReader(new FileReader(clusterFile)));
        File storeDefFile = new File((String)options.valueOf("storedefinitions"));
        String storeName = (String)options.valueOf("storename");
        List stores = new StoreDefinitionsMapper().readStoreList((Reader)new BufferedReader(new FileReader(storeDefFile)));
        StoreDefinition storeDef = null;
        for (StoreDefinition def : stores) {
            if (!def.getName().equals(storeName)) continue;
            storeDef = def;
        }
        int replicationFactor = Integer.parseInt((String)CmdUtils.valueOf((OptionSet)options, (String)"replication", (Object)"2"));
        long chunkSizeBytes = Long.parseLong((String)options.valueOf("chunksize"));
        Path inputPath = new Path((String)options.valueOf("input"));
        Path tempDir = new Path((String)options.valueOf("tmpdir"));
        Path outputDir = new Path((String)options.valueOf("output"));
        ArrayList<String> addJars = new ArrayList<String>();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (options.has("jar")) {
            String jar = (String)options.valueOf("jar");
            URL[] urls = new URL[]{new File(jar).toURI().toURL()};
            cl = new URLClassLoader(urls);
            addJars.add(jar);
        }
        Class mapperClass = ReflectUtils.loadClass((String)((String)options.valueOf("mapper")), (ClassLoader)cl);
        Class inputFormatClass = TextInputFormat.class;
        if (options.has("inputformat") && !(inputFormatClassName = (String)options.valueOf("inputformat")).equalsIgnoreCase("TextInputFormat")) {
            inputFormatClass = ReflectUtils.loadClass((String)inputFormatClassName, (ClassLoader)cl);
        }
        if (inputFormatClass == null) {
            inputFormatClass = TextInputFormat.class;
        }
        Configuration conf = this.getConf();
        if (options.has("force-overwrite")) {
            FileSystem fs = outputDir.getFileSystem(conf);
            fs.delete(outputDir, true);
        }
        CheckSum.CheckSumType checkSumType = CheckSum.CheckSumType.toType((String)CmdUtils.valueOf((OptionSet)options, (String)"checksum", (Object)""));
        Class[] deps = new Class[]{ImmutableCollection.class, JDOMException.class, VoldemortConfig.class, HadoopStoreJobRunner.class, mapperClass};
        HadoopStoreJobRunner.addDepJars(conf, deps, addJars);
        HadoopStoreBuilder builder = new HadoopStoreBuilder(conf, mapperClass, inputFormatClass, cluster, storeDef, replicationFactor, chunkSizeBytes, tempDir, outputDir, inputPath, checkSumType);
        builder.build();
        return 0;
    }

    public static String findInClasspath(String className) {
        return HadoopStoreJobRunner.findInClasspath(className, HadoopStoreJobRunner.class.getClassLoader());
    }

    public static String findInClasspath(String className, ClassLoader loader) {
        String codePath;
        String relPath = className;
        relPath = relPath.replace('.', '/');
        URL classUrl = loader.getResource(relPath = relPath + ".class");
        if (classUrl != null) {
            boolean inJar = classUrl.getProtocol().equals("jar");
            codePath = classUrl.toString();
            if (codePath.startsWith("jar:")) {
                codePath = codePath.substring("jar:".length());
            }
            if (codePath.startsWith("file:")) {
                codePath = codePath.substring("file:".length());
            }
            if (inJar) {
                int bang = codePath.lastIndexOf(33);
                codePath = codePath.substring(0, bang);
            } else {
                int pos = codePath.lastIndexOf(relPath);
                if (pos == -1) {
                    throw new IllegalArgumentException("invalid codePath: className=" + className + " codePath=" + codePath);
                }
                codePath = codePath.substring(0, pos);
            }
        } else {
            codePath = null;
        }
        return codePath;
    }

    private static void addDepJars(Configuration conf, Class<?>[] deps, List<String> additionalJars) throws IOException {
        String[] tmpjars;
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> depJars = new HashSet<String>();
        for (Class<?> dep : deps) {
            String tmp = HadoopStoreJobRunner.findInClasspath(dep.getCanonicalName());
            if (tmp == null) continue;
            Path path = new Path(tmp);
            depJars.add(path.makeQualified((FileSystem)localFs).toString());
        }
        for (String additional : additionalJars) {
            Path path = new Path(additional);
            depJars.add(path.makeQualified((FileSystem)localFs).toString());
        }
        for (String tmpjar : tmpjars = conf.get("tmpjars", "").split(",")) {
            if (StringUtils.isEmpty((String)tmpjar)) continue;
            depJars.add(tmpjar.trim());
        }
        conf.set("tmpjars", StringUtils.join(depJars.iterator(), (char)','));
    }

    public static void main(String[] args) {
        try {
            int res = ToolRunner.run((Configuration)new Configuration(), (Tool)new HadoopStoreJobRunner(), (String[])args);
            System.exit(res);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.print("\nTry '--help' for more information.");
            System.exit(1);
        }
    }
}

