/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.mr;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.TextInputFormat;
import voldemort.ServerTestUtils;
import voldemort.TestUtils;
import voldemort.client.RoutingTier;
import voldemort.cluster.Cluster;
import voldemort.routing.RoutingStrategyType;
import voldemort.serialization.DefaultSerializerFactory;
import voldemort.serialization.Serializer;
import voldemort.serialization.SerializerDefinition;
import voldemort.store.Store;
import voldemort.store.StoreDefinition;
import voldemort.store.StoreDefinitionBuilder;
import voldemort.store.readonly.BinarySearchStrategy;
import voldemort.store.readonly.ReadOnlyStorageEngine;
import voldemort.store.readonly.SearchStrategy;
import voldemort.store.readonly.checksum.CheckSum;
import voldemort.store.readonly.checksum.CheckSumTests;
import voldemort.store.readonly.mr.AbstractHadoopStoreBuilderMapper;
import voldemort.store.readonly.mr.HadoopStoreBuilder;
import voldemort.store.serialized.SerializingStore;
import voldemort.utils.ByteUtils;
import voldemort.versioning.Versioned;

public class HadoopStoreBuilderTest
extends TestCase {
    public void testHadoopBuild() throws Exception {
        HashMap<String, String> values = new HashMap<String, String>();
        File testDir = TestUtils.createTempDir();
        File tempDir = new File(testDir, "temp");
        File tempDir2 = new File(testDir, "temp2");
        File outputDir = new File(testDir, "output");
        File outputDir2 = new File(testDir, "output2");
        File storeDir = TestUtils.createTempDir((File)testDir);
        for (int i = 0; i < 200; ++i) {
            values.put(Integer.toString(i), Integer.toBinaryString(i));
        }
        File inputFile = File.createTempFile("input", ".txt", testDir);
        inputFile.deleteOnExit();
        StringBuilder contents = new StringBuilder();
        for (Map.Entry entry : values.entrySet()) {
            contents.append((String)entry.getKey() + "\t" + (String)entry.getValue() + "\n");
        }
        FileUtils.writeStringToFile((File)inputFile, (String)contents.toString());
        String storeName = "test";
        SerializerDefinition serDef = new SerializerDefinition("string");
        Cluster cluster = ServerTestUtils.getLocalCluster((int)1);
        StoreDefinition def = new StoreDefinitionBuilder().setName(storeName).setType("read-only").setKeySerializer(serDef).setValueSerializer(serDef).setRoutingPolicy(RoutingTier.CLIENT).setRoutingStrategyType(RoutingStrategyType.CONSISTENT_STRATEGY).setReplicationFactor(1).setPreferredReads(Integer.valueOf(1)).setRequiredReads(1).setPreferredWrites(Integer.valueOf(1)).setRequiredWrites(1).build();
        HadoopStoreBuilder builder = new HadoopStoreBuilder(new Configuration(), TextStoreMapper.class, TextInputFormat.class, cluster, def, 2, 65536L, new Path(tempDir2.getAbsolutePath()), new Path(outputDir2.getAbsolutePath()), new Path(inputFile.getAbsolutePath()));
        builder.build();
        builder = new HadoopStoreBuilder(new Configuration(), TextStoreMapper.class, TextInputFormat.class, cluster, def, 2, 65536L, new Path(tempDir.getAbsolutePath()), new Path(outputDir.getAbsolutePath()), new Path(inputFile.getAbsolutePath()), CheckSum.CheckSumType.MD5);
        builder.build();
        File nodeFile = new File(outputDir, "node-0");
        File checkSumFile = new File(nodeFile, "md5checkSum.txt");
        HadoopStoreBuilderTest.assertTrue((boolean)checkSumFile.exists());
        byte[] md5 = new byte[16];
        DataInputStream in = new DataInputStream(new FileInputStream(checkSumFile));
        in.read(md5);
        in.close();
        checkSumFile.delete();
        byte[] checkSumBytes = CheckSumTests.calculateCheckSum(nodeFile.listFiles(), CheckSum.CheckSumType.MD5);
        HadoopStoreBuilderTest.assertEquals((int)0, (int)ByteUtils.compare((byte[])checkSumBytes, (byte[])md5));
        File versionDir = new File(storeDir, "version-0");
        versionDir.mkdirs();
        HadoopStoreBuilderTest.assertTrue((String)"Rename failed.", (boolean)nodeFile.renameTo(versionDir));
        Serializer serializer = new DefaultSerializerFactory().getSerializer(serDef);
        SerializingStore store = SerializingStore.wrap((Store)new ReadOnlyStorageEngine(storeName, (SearchStrategy)new BinarySearchStrategy(), storeDir, 1), (Serializer)serializer, (Serializer)serializer);
        for (Map.Entry entry : values.entrySet()) {
            List found = store.get(entry.getKey());
            HadoopStoreBuilderTest.assertEquals((String)"Incorrect number of results", (int)1, (int)found.size());
            HadoopStoreBuilderTest.assertEquals(entry.getValue(), (Object)((Versioned)found.get(0)).getValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TextStoreMapper
    extends AbstractHadoopStoreBuilderMapper<LongWritable, Text> {
        @Override
        public Object makeKey(LongWritable key, Text value) {
            String[] tokens = value.toString().split("\\s+");
            return tokens[0];
        }

        @Override
        public Object makeValue(LongWritable key, Text value) {
            String[] tokens = value.toString().split("\\s+");
            return tokens[1];
        }
    }
}

