/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.mr;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reducer;
import org.apache.hadoop.mapred.Reporter;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.store.readonly.ReadOnlyUtils;
import voldemort.store.readonly.checksum.CheckSum;
import voldemort.store.readonly.mr.AbstractStoreBuilderConfigurable;
import voldemort.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HadoopStoreBuilderReducer
extends AbstractStoreBuilderConfigurable
implements Reducer<BytesWritable, BytesWritable, Text, Text> {
    private static final Logger logger = Logger.getLogger(HadoopStoreBuilderReducer.class);
    private DataOutputStream indexFileStream = null;
    private DataOutputStream valueFileStream = null;
    private int position = 0;
    private String taskId = null;
    private int numChunks = -1;
    private int nodeId = -1;
    private int chunkId = -1;
    private Path taskIndexFileName;
    private Path taskValueFileName;
    private String outputDir;
    private JobConf conf;
    private CheckSum.CheckSumType checkSumType;
    private CheckSum checkSumDigestIndex;
    private CheckSum checkSumDigestValue;

    public void reduce(BytesWritable key, Iterator<BytesWritable> values, OutputCollector<Text, Text> output, Reporter reporter) throws IOException {
        BytesWritable writable = values.next();
        byte[] valueBytes = writable.get();
        if (this.nodeId == -1) {
            this.nodeId = ByteUtils.readInt((byte[])valueBytes, (int)0);
        }
        if (this.chunkId == -1) {
            this.chunkId = ReadOnlyUtils.chunk((byte[])key.get(), (int)this.numChunks);
        }
        this.indexFileStream.write(key.get(), 0, key.getSize());
        this.indexFileStream.writeInt(this.position);
        if (this.checkSumDigestIndex != null) {
            this.checkSumDigestIndex.update(key.get(), 0, key.getSize());
            this.checkSumDigestIndex.update(this.position);
        }
        int valueLength = writable.getSize() - 4;
        this.valueFileStream.writeInt(valueLength);
        this.valueFileStream.write(valueBytes, 4, valueLength);
        if (this.checkSumDigestValue != null) {
            this.checkSumDigestValue.update(valueLength);
            this.checkSumDigestValue.update(valueBytes, 4, valueLength);
        }
        this.position += 4 + valueLength;
        if (this.position < 0) {
            throw new VoldemortException("Chunk overflow exception: chunk " + this.chunkId + " has exceeded " + Integer.MAX_VALUE + " bytes.");
        }
        if (values.hasNext()) {
            throw new VoldemortException("Duplicate keys detected for md5 sum " + ByteUtils.toHexString((byte[])ByteUtils.copy((byte[])key.get(), (int)0, (int)key.getSize())));
        }
    }

    @Override
    public void configure(JobConf job) {
        super.configure(job);
        try {
            this.conf = job;
            this.position = 0;
            this.numChunks = job.getInt("num.chunks", -1);
            this.outputDir = job.get("final.output.dir");
            this.taskId = job.get("mapred.task.id");
            this.checkSumType = CheckSum.fromString(job.get("checksum.type"));
            this.checkSumDigestIndex = CheckSum.getInstance(this.checkSumType);
            this.checkSumDigestValue = CheckSum.getInstance(this.checkSumType);
            this.taskIndexFileName = new Path(FileOutputFormat.getOutputPath((JobConf)job), this.getStoreName() + "." + this.taskId + ".index");
            this.taskValueFileName = new Path(FileOutputFormat.getOutputPath((JobConf)job), this.getStoreName() + "." + this.taskId + ".data");
            int replicationFactor = job.getInt("store.output.replication.factor", 2);
            logger.info((Object)("Opening " + this.taskIndexFileName + " and " + this.taskValueFileName + " for writing."));
            FileSystem fs = this.taskIndexFileName.getFileSystem((Configuration)job);
            this.indexFileStream = fs.create(this.taskIndexFileName);
            this.valueFileStream = fs.create(this.taskValueFileName);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to open Input/OutputStream", e);
        }
    }

    @Override
    public void close() throws IOException {
        this.indexFileStream.close();
        this.valueFileStream.close();
        Path nodeDir = new Path(this.outputDir, "node-" + this.nodeId);
        Path indexFile = new Path(nodeDir, this.chunkId + ".index");
        Path valueFile = new Path(nodeDir, this.chunkId + ".data");
        FileSystem fs = indexFile.getFileSystem((Configuration)this.conf);
        fs.mkdirs(nodeDir);
        if (this.checkSumType != CheckSum.CheckSumType.NONE) {
            if (this.checkSumDigestIndex != null && this.checkSumDigestValue != null) {
                Path checkSumIndexFile = new Path(nodeDir, this.chunkId + ".index.checksum");
                Path checkSumValueFile = new Path(nodeDir, this.chunkId + ".data.checksum");
                FSDataOutputStream output = fs.create(checkSumIndexFile);
                output.write(this.checkSumDigestIndex.getCheckSum());
                output.close();
                output = fs.create(checkSumValueFile);
                output.write(this.checkSumDigestValue.getCheckSum());
                output.close();
            } else {
                throw new VoldemortException("Failed to open CheckSum digest");
            }
        }
        logger.info((Object)("Moving " + this.taskIndexFileName + " to " + indexFile + "."));
        fs.rename(this.taskIndexFileName, indexFile);
        logger.info((Object)("Moving " + this.taskValueFileName + " to " + valueFile + "."));
        fs.rename(this.taskValueFileName, valueFile);
    }
}

