/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.mr;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.List;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;
import voldemort.cluster.Node;
import voldemort.routing.ConsistentRoutingStrategy;
import voldemort.serialization.DefaultSerializerFactory;
import voldemort.serialization.Serializer;
import voldemort.serialization.SerializerDefinition;
import voldemort.serialization.SerializerFactory;
import voldemort.store.compress.CompressionStrategy;
import voldemort.store.compress.CompressionStrategyFactory;
import voldemort.store.readonly.mr.AbstractStoreBuilderConfigurable;
import voldemort.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractHadoopStoreBuilderMapper<K, V>
extends AbstractStoreBuilderConfigurable
implements Mapper<K, V, BytesWritable, BytesWritable> {
    private MessageDigest md5er;
    private ConsistentRoutingStrategy routingStrategy;
    private Serializer<Object> keySerializer;
    private Serializer<Object> valueSerializer;
    private CompressionStrategy valueCompressor;
    private CompressionStrategy keyCompressor;
    private SerializerDefinition keySerializerDefinition;
    private SerializerDefinition valueSerializerDefinition;

    public abstract Object makeKey(K var1, V var2);

    public abstract Object makeValue(K var1, V var2);

    public void map(K key, V value, OutputCollector<BytesWritable, BytesWritable> output, Reporter reporter) throws IOException {
        byte[] keyBytes = this.keySerializer.toBytes(this.makeKey(key, value));
        byte[] valBytes = this.valueSerializer.toBytes(this.makeValue(key, value));
        if (this.keySerializerDefinition.hasCompression()) {
            keyBytes = this.keyCompressor.deflate(keyBytes);
        }
        if (this.valueSerializerDefinition.hasCompression()) {
            valBytes = this.valueCompressor.deflate(valBytes);
        }
        byte[] nodeIdAndValue = new byte[valBytes.length + 4];
        System.arraycopy(valBytes, 0, nodeIdAndValue, 4, valBytes.length);
        BytesWritable outputKey = new BytesWritable(this.md5er.digest(keyBytes));
        List nodes = this.routingStrategy.routeRequest(keyBytes);
        for (Node node : nodes) {
            ByteUtils.writeInt((byte[])nodeIdAndValue, (int)node.getId(), (int)0);
            BytesWritable outputVal = new BytesWritable(nodeIdAndValue);
            output.collect((Object)outputKey, (Object)outputVal);
        }
        this.md5er.reset();
    }

    @Override
    public void configure(JobConf conf) {
        super.configure(conf);
        this.md5er = ByteUtils.getDigest((String)"md5");
        this.keySerializerDefinition = this.getStoreDef().getKeySerializer();
        this.valueSerializerDefinition = this.getStoreDef().getValueSerializer();
        try {
            DefaultSerializerFactory factory = new DefaultSerializerFactory();
            if (conf.get("serializer.factory") != null) {
                factory = (SerializerFactory)Class.forName(conf.get("serializer.factory")).newInstance();
            }
            this.keySerializer = factory.getSerializer(this.keySerializerDefinition);
            this.valueSerializer = factory.getSerializer(this.valueSerializerDefinition);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.keyCompressor = new CompressionStrategyFactory().get(this.keySerializerDefinition.getCompression());
        this.valueCompressor = new CompressionStrategyFactory().get(this.valueSerializerDefinition.getCompression());
        this.routingStrategy = new ConsistentRoutingStrategy(this.getCluster().getNodes(), this.getStoreDef().getReplicationFactor());
    }
}

