/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.fetcher;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import junit.framework.TestCase;
import voldemort.TestUtils;
import voldemort.store.readonly.checksum.CheckSum;
import voldemort.store.readonly.checksum.CheckSumTests;
import voldemort.store.readonly.fetcher.HdfsFetcher;

public class HdfsFetcherTest
extends TestCase {
    public void testFetch() throws Exception {
        File testDirectory = TestUtils.createTempDir();
        File testFile = File.createTempFile("test", ".dat", testDirectory);
        testFile.createNewFile();
        HdfsFetcher fetcher = new HdfsFetcher();
        File fetchedFile = fetcher.fetch(testDirectory.getAbsolutePath(), "storeName");
        HdfsFetcherTest.assertNotNull((Object)fetchedFile);
        File checkSumFile = new File(testDirectory, "blahcheckSum.txt");
        checkSumFile.createNewFile();
        fetchedFile = fetcher.fetch(testDirectory.getAbsolutePath(), "storeName");
        HdfsFetcherTest.assertNotNull((Object)fetchedFile);
        checkSumFile.delete();
        checkSumFile = new File(testDirectory, "adler32checkSum.txt");
        checkSumFile.createNewFile();
        fetchedFile = fetcher.fetch(testDirectory.getAbsolutePath(), "storeName");
        HdfsFetcherTest.assertNull((Object)fetchedFile);
        byte[] checkSumBytes = CheckSumTests.calculateCheckSum(testDirectory.listFiles(), CheckSum.CheckSumType.CRC32);
        DataOutputStream os = new DataOutputStream(new FileOutputStream(checkSumFile));
        os.write(checkSumBytes);
        os.close();
        fetchedFile = fetcher.fetch(testDirectory.getAbsolutePath(), "storeName");
        HdfsFetcherTest.assertNull((Object)fetchedFile);
        checkSumFile.delete();
        checkSumFile = new File(testDirectory, "md5checkSum.txt");
        byte[] checkSumBytes2 = CheckSumTests.calculateCheckSum(testDirectory.listFiles(), CheckSum.CheckSumType.MD5);
        os = new DataOutputStream(new FileOutputStream(checkSumFile));
        os.write(checkSumBytes2);
        os.close();
        fetchedFile = fetcher.fetch(testDirectory.getAbsolutePath(), "storeName");
        HdfsFetcherTest.assertNotNull((Object)fetchedFile);
        checkSumFile.delete();
        checkSumFile = new File(testDirectory, "adler32checkSum.txt");
        byte[] checkSumBytes3 = CheckSumTests.calculateCheckSum(testDirectory.listFiles(), CheckSum.CheckSumType.ADLER32);
        os = new DataOutputStream(new FileOutputStream(checkSumFile));
        os.write(checkSumBytes3);
        os.close();
        fetchedFile = fetcher.fetch(testDirectory.getAbsolutePath(), "storeName");
        HdfsFetcherTest.assertNotNull((Object)fetchedFile);
        checkSumFile.delete();
        checkSumFile = new File(testDirectory, "crc32checkSum.txt");
        byte[] checkSumBytes4 = CheckSumTests.calculateCheckSum(testDirectory.listFiles(), CheckSum.CheckSumType.CRC32);
        os = new DataOutputStream(new FileOutputStream(checkSumFile));
        os.write(checkSumBytes4);
        os.close();
        fetchedFile = fetcher.fetch(testDirectory.getAbsolutePath(), "storeName");
        HdfsFetcherTest.assertNotNull((Object)fetchedFile);
        checkSumFile.delete();
    }
}

