/*
 * Decompiled with CFR 0.152.
 */
package voldemort.store.readonly.fetcher;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import javax.net.SocketFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;

class ConfigurableSocketFactory
extends SocketFactory
implements Configurable {
    private static final Logger logger = Logger.getLogger(ConfigurableSocketFactory.class);
    private Configuration configuration;
    private int socketReceiveBufferSize = -1;

    ConfigurableSocketFactory() {
    }

    public Socket createSocket() throws IOException {
        return this.applySettings(SocketChannel.open().socket());
    }

    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        Socket socket = this.applySettings(this.createSocket());
        socket.bind(new InetSocketAddress(address, localPort));
        socket.connect(new InetSocketAddress(localAddress, port));
        return socket;
    }

    public Socket createSocket(InetAddress host, int port) throws IOException {
        Socket socket = this.applySettings(this.createSocket());
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }

    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException, UnknownHostException {
        Socket socket = this.applySettings(this.createSocket());
        socket.bind(new InetSocketAddress(host, localPort));
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        Socket socket = this.applySettings(this.createSocket());
        socket.connect(new InetSocketAddress(host, port));
        return socket;
    }

    public Configuration getConf() {
        return this.configuration;
    }

    public void setConf(Configuration conf) {
        this.configuration = conf;
        this.socketReceiveBufferSize = conf.getInt("io.socket.receive.buffer", 0x6400000);
    }

    private Socket applySettings(Socket s) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Attempting to set socket receive buffer of " + this.socketReceiveBufferSize + " bytes"));
        }
        s.setReceiveBufferSize(this.socketReceiveBufferSize);
        if (logger.isDebugEnabled()) {
            logger.info((Object)("Actually set socket receive buffer to " + s.getReceiveBufferSize() + " bytes"));
        }
        return s;
    }

    static {
        logger.info((Object)"----- Using configurable socket factory -------");
    }
}

